/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.genesis.GenesisFile;
import com.bloxbean.cardano.yaci.store.events.GenesisBalance;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ShelleyGenesis
extends GenesisFile {
    public static final String ATTR_SYSTEM_START = "systemStart";
    public static final String ATTR_SLOT_LENGTH = "slotLength";
    public static final String ATTR_ACTIVE_SLOTS_COEFF = "activeSlotsCoeff";
    public static final String ATTR_MAX_LOVELACE_SUPPLY = "maxLovelaceSupply";
    public static final String ATTR_EPOCH_LENGTH = "epochLength";
    public static final String ATTR_NETWORK_MAGIC = "networkMagic";
    public static final String MIN_FEE_A = "minFeeA";
    public static final String MIN_FEE_B = "minFeeB";
    public static final String MAX_BLOCK_BODY_SIZE = "maxBlockBodySize";
    public static final String MAX_TX_SIZE = "maxTxSize";
    public static final String MAX_BLOCK_HEADER_SIZE = "maxBlockHeaderSize";
    public static final String KEY_DEPOSIT = "keyDeposit";
    public static final String POOL_DEPOSIT = "poolDeposit";
    public static final String E_MAX = "eMax";
    public static final String N_OPT = "nOpt";
    public static final String A_0 = "a0";
    public static final String RHO = "rho";
    public static final String TAU = "tau";
    public static final String DECENTRALISATION_PARAM = "decentralisationParam";
    public static final String EXTRA_ENTROPY = "extraEntropy";
    public static final String TAG = "tag";
    public static final String PROTOCOL_VERSION = "protocolVersion";
    public static final String MAJOR = "major";
    public static final String MINOR = "minor";
    public static final String MIN_U_TX_O_VALUE = "minUTxOValue";
    public static final String MIN_POOL_COST = "minPoolCost";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private String systemStart;
    private double slotLength;
    private double activeSlotsCoeff;
    private BigInteger maxLovelaceSupply;
    private long epochLength;
    private long networkMagic;
    private List<GenesisBalance> initialFunds;
    private ProtocolParams protocolParams;

    public ShelleyGenesis(File shelleyGenesisFile) {
        super(shelleyGenesisFile);
    }

    public ShelleyGenesis(InputStream in) {
        super(in);
    }

    public ShelleyGenesis(long protocolMagic) {
        super(protocolMagic);
    }

    @Override
    protected void readGenesisData(JsonNode genesisJson) {
        this.systemStart = genesisJson.get(ATTR_SYSTEM_START).asText();
        this.slotLength = genesisJson.get(ATTR_SLOT_LENGTH).asDouble();
        this.activeSlotsCoeff = genesisJson.get(ATTR_ACTIVE_SLOTS_COEFF).asDouble();
        this.maxLovelaceSupply = new BigInteger(genesisJson.get(ATTR_MAX_LOVELACE_SUPPLY).asText());
        this.epochLength = genesisJson.get(ATTR_EPOCH_LENGTH).asLong();
        this.networkMagic = genesisJson.get(ATTR_NETWORK_MAGIC).asLong();
        JsonNode initialFundJson = genesisJson.get("initialFunds");
        this.initialFunds = new ArrayList<GenesisBalance>();
        if (initialFundJson != null && initialFundJson.fields().hasNext()) {
            initialFundJson.fields().forEachRemaining(entry -> {
                String address = (String)entry.getKey();
                BigInteger amount = new BigInteger(((JsonNode)entry.getValue()).asText());
                String shelleyAddr = Networks.mainnet().getProtocolMagic() == this.networkMagic ? new Address("addr", HexUtil.decodeHexString((String)address)).toBech32() : new Address("addr_test", HexUtil.decodeHexString((String)address)).toBech32();
                String txHash = HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])HexUtil.decodeHexString((String)address)));
                this.initialFunds.add(new GenesisBalance(shelleyAddr, txHash, amount));
            });
        }
        this.readProtocolParameters(genesisJson.get("protocolParams"));
    }

    @Override
    protected String getFileName() {
        return "shelley-genesis.json";
    }

    public void readProtocolParameters(JsonNode protocolParamsNode) {
        if (protocolParamsNode == null) {
            return;
        }
        int minFeeA = protocolParamsNode.get(MIN_FEE_A).asInt();
        int minFeeB = protocolParamsNode.get(MIN_FEE_B).asInt();
        int maxBlockSize = protocolParamsNode.get(MAX_BLOCK_BODY_SIZE).asInt();
        int maxTxSize = protocolParamsNode.get(MAX_TX_SIZE).asInt();
        int maxBlockHeaderSize = protocolParamsNode.get(MAX_BLOCK_HEADER_SIZE).asInt();
        BigInteger keyDeposit = protocolParamsNode.get(KEY_DEPOSIT).bigIntegerValue();
        BigInteger poolDeposit = protocolParamsNode.get(POOL_DEPOSIT).bigIntegerValue();
        int maxEpoch = protocolParamsNode.get(E_MAX).asInt();
        int nOpt = protocolParamsNode.get(N_OPT).asInt();
        BigDecimal poolPledgeInfluence = protocolParamsNode.get(A_0).decimalValue();
        BigDecimal monetaryExpansionRate = protocolParamsNode.get(RHO).decimalValue();
        BigDecimal treasuryGrowthRate = protocolParamsNode.get(TAU).decimalValue();
        BigDecimal decentralisationParam = protocolParamsNode.get(DECENTRALISATION_PARAM).decimalValue();
        JsonNode extraEntropyNode = protocolParamsNode.get(EXTRA_ENTROPY);
        String extraEntropy = extraEntropyNode != null ? extraEntropyNode.get(TAG).asText() : null;
        JsonNode protocolVersionNode = protocolParamsNode.get(PROTOCOL_VERSION);
        int majorVersion = protocolVersionNode.get(MAJOR).asInt();
        int minorVersion = protocolVersionNode.get(MINOR).asInt();
        BigInteger minUTxOValue = protocolParamsNode.get(MIN_U_TX_O_VALUE).bigIntegerValue();
        BigInteger minPoolCost = protocolParamsNode.get(MIN_POOL_COST).bigIntegerValue();
        this.protocolParams = ProtocolParams.builder().minFeeA(minFeeA).minFeeB(minFeeB).maxBlockSize(maxBlockSize).maxTxSize(maxTxSize).maxBlockHeaderSize(maxBlockHeaderSize).keyDeposit(keyDeposit).poolDeposit(poolDeposit).maxEpoch(maxEpoch).nOpt(nOpt).poolPledgeInfluence(poolPledgeInfluence).expansionRate(monetaryExpansionRate).treasuryGrowthRate(treasuryGrowthRate).decentralisationParam(decentralisationParam).protocolMajorVer(majorVersion).protocolMinorVer(minorVersion).minUtxo(minUTxOValue).minPoolCost(minPoolCost).build();
    }

    public String getSystemStart() {
        return this.systemStart;
    }

    public double getSlotLength() {
        return this.slotLength;
    }

    public double getActiveSlotsCoeff() {
        return this.activeSlotsCoeff;
    }

    public BigInteger getMaxLovelaceSupply() {
        return this.maxLovelaceSupply;
    }

    public long getEpochLength() {
        return this.epochLength;
    }

    public long getNetworkMagic() {
        return this.networkMagic;
    }

    public List<GenesisBalance> getInitialFunds() {
        return this.initialFunds;
    }

    @Override
    public ProtocolParams getProtocolParams() {
        return this.protocolParams;
    }

    public void setSystemStart(String systemStart) {
        this.systemStart = systemStart;
    }

    public void setSlotLength(double slotLength) {
        this.slotLength = slotLength;
    }

    public void setActiveSlotsCoeff(double activeSlotsCoeff) {
        this.activeSlotsCoeff = activeSlotsCoeff;
    }

    public void setMaxLovelaceSupply(BigInteger maxLovelaceSupply) {
        this.maxLovelaceSupply = maxLovelaceSupply;
    }

    public void setEpochLength(long epochLength) {
        this.epochLength = epochLength;
    }

    public void setNetworkMagic(long networkMagic) {
        this.networkMagic = networkMagic;
    }

    public void setInitialFunds(List<GenesisBalance> initialFunds) {
        this.initialFunds = initialFunds;
    }

    public void setProtocolParams(ProtocolParams protocolParams) {
        this.protocolParams = protocolParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShelleyGenesis)) {
            return false;
        }
        ShelleyGenesis other = (ShelleyGenesis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSlotLength(), other.getSlotLength()) != 0) {
            return false;
        }
        if (Double.compare(this.getActiveSlotsCoeff(), other.getActiveSlotsCoeff()) != 0) {
            return false;
        }
        if (this.getEpochLength() != other.getEpochLength()) {
            return false;
        }
        if (this.getNetworkMagic() != other.getNetworkMagic()) {
            return false;
        }
        String this$systemStart = this.getSystemStart();
        String other$systemStart = other.getSystemStart();
        if (this$systemStart == null ? other$systemStart != null : !this$systemStart.equals(other$systemStart)) {
            return false;
        }
        BigInteger this$maxLovelaceSupply = this.getMaxLovelaceSupply();
        BigInteger other$maxLovelaceSupply = other.getMaxLovelaceSupply();
        if (this$maxLovelaceSupply == null ? other$maxLovelaceSupply != null : !((Object)this$maxLovelaceSupply).equals(other$maxLovelaceSupply)) {
            return false;
        }
        List<GenesisBalance> this$initialFunds = this.getInitialFunds();
        List<GenesisBalance> other$initialFunds = other.getInitialFunds();
        if (this$initialFunds == null ? other$initialFunds != null : !((Object)this$initialFunds).equals(other$initialFunds)) {
            return false;
        }
        ProtocolParams this$protocolParams = this.getProtocolParams();
        ProtocolParams other$protocolParams = other.getProtocolParams();
        return !(this$protocolParams == null ? other$protocolParams != null : !((Object)this$protocolParams).equals(other$protocolParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShelleyGenesis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $slotLength = Double.doubleToLongBits(this.getSlotLength());
        result = result * 59 + (int)($slotLength >>> 32 ^ $slotLength);
        long $activeSlotsCoeff = Double.doubleToLongBits(this.getActiveSlotsCoeff());
        result = result * 59 + (int)($activeSlotsCoeff >>> 32 ^ $activeSlotsCoeff);
        long $epochLength = this.getEpochLength();
        result = result * 59 + (int)($epochLength >>> 32 ^ $epochLength);
        long $networkMagic = this.getNetworkMagic();
        result = result * 59 + (int)($networkMagic >>> 32 ^ $networkMagic);
        String $systemStart = this.getSystemStart();
        result = result * 59 + ($systemStart == null ? 43 : $systemStart.hashCode());
        BigInteger $maxLovelaceSupply = this.getMaxLovelaceSupply();
        result = result * 59 + ($maxLovelaceSupply == null ? 43 : ((Object)$maxLovelaceSupply).hashCode());
        List<GenesisBalance> $initialFunds = this.getInitialFunds();
        result = result * 59 + ($initialFunds == null ? 43 : ((Object)$initialFunds).hashCode());
        ProtocolParams $protocolParams = this.getProtocolParams();
        result = result * 59 + ($protocolParams == null ? 43 : ((Object)$protocolParams).hashCode());
        return result;
    }

    public String toString() {
        return "ShelleyGenesis(systemStart=" + this.getSystemStart() + ", slotLength=" + this.getSlotLength() + ", activeSlotsCoeff=" + this.getActiveSlotsCoeff() + ", maxLovelaceSupply=" + String.valueOf(this.getMaxLovelaceSupply()) + ", epochLength=" + this.getEpochLength() + ", networkMagic=" + this.getNetworkMagic() + ", initialFunds=" + String.valueOf(this.getInitialFunds()) + ", protocolParams=" + String.valueOf(this.getProtocolParams()) + ")";
    }
}

