/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.util;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.util.HexUtil;

public class PlutusV3Script
extends PlutusScript {
    public PlutusV3Script() {
        this.type = "PlutusScriptV3";
    }

    public static PlutusV3Script deserialize(ByteString plutusScriptDI) throws CborDeserializationException {
        if (plutusScriptDI != null) {
            byte[] bytes;
            PlutusV3Script plutusScript = new PlutusV3Script();
            try {
                bytes = CborSerializationUtil.serialize((DataItem)plutusScriptDI);
            }
            catch (CborException e) {
                throw new CborDeserializationException("CBor deserialization error", (Exception)((Object)e));
            }
            plutusScript.setCborHex(HexUtil.encodeHexString((byte[])bytes));
            return plutusScript;
        }
        return null;
    }

    public byte[] getScriptTypeBytes() {
        return new byte[]{(byte)this.getScriptType()};
    }

    public int getScriptType() {
        return 3;
    }

    protected PlutusV3Script(PlutusV3ScriptBuilder<?, ?> b) {
        super(b);
    }

    public static PlutusV3ScriptBuilder<?, ?> builder() {
        return new PlutusV3ScriptBuilderImpl();
    }

    private static final class PlutusV3ScriptBuilderImpl
    extends PlutusV3ScriptBuilder<PlutusV3Script, PlutusV3ScriptBuilderImpl> {
        private PlutusV3ScriptBuilderImpl() {
        }

        @Override
        protected PlutusV3ScriptBuilderImpl self() {
            return this;
        }

        @Override
        public PlutusV3Script build() {
            return new PlutusV3Script(this);
        }
    }

    public static abstract class PlutusV3ScriptBuilder<C extends PlutusV3Script, B extends PlutusV3ScriptBuilder<C, B>>
    extends PlutusScript.PlutusScriptBuilder<C, B> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "PlutusV3Script.PlutusV3ScriptBuilder(super=" + super.toString() + ")";
        }
    }
}

