/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.genesis.GenesisFile;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import lombok.Generated;

public class AlonzoGenesis
extends GenesisFile {
    private static final String LOVELACE_PER_UTXO_WORD = "lovelacePerUTxOWord";
    private static final String EXECUTION_PRICES = "executionPrices";
    private static final String PR_STEPS = "prSteps";
    private static final String PR_MEM = "prMem";
    private static final String NUMERATOR = "numerator";
    private static final String DENOMINATOR = "denominator";
    private static final String MAX_TX_EX_UNITS = "maxTxExUnits";
    private static final String EX_UNITS_MEM = "exUnitsMem";
    private static final String EX_UNITS_STEPS = "exUnitsSteps";
    private static final String MAX_BLOCK_EX_UNITS = "maxBlockExUnits";
    private static final String MAX_VALUE_SIZE = "maxValueSize";
    private static final String COLLATERAL_PERCENTAGE = "collateralPercentage";
    private static final String MAX_COLLATERAL_INPUTS = "maxCollateralInputs";
    private static final String COST_MODELS = "costModels";
    private ObjectMapper objectMapper;

    public AlonzoGenesis() {
    }

    public AlonzoGenesis(File shelleyGenesisFile) {
        super(shelleyGenesisFile);
    }

    public AlonzoGenesis(InputStream in) {
        super(in);
    }

    public AlonzoGenesis(long protocolMagic) {
        super(protocolMagic);
    }

    @Override
    protected void readGenesisData(JsonNode genesisJson) {
        BigDecimal priceMem;
        BigDecimal priceSteps;
        this.objectMapper = new ObjectMapper();
        BigInteger lovelacePerUTxOWord = genesisJson.get(LOVELACE_PER_UTXO_WORD).bigIntegerValue();
        JsonNode executionPriceNode = genesisJson.get(EXECUTION_PRICES);
        JsonNode prStepsNode = executionPriceNode.get(PR_STEPS);
        JsonNode prMemNode = executionPriceNode.get(PR_MEM);
        if (prStepsNode.isObject()) {
            BigDecimal prStepsNumerator = prStepsNode.get(NUMERATOR).decimalValue();
            BigDecimal prStepsDenominator = prStepsNode.get(DENOMINATOR).decimalValue();
            priceSteps = prStepsNumerator.divide(prStepsDenominator);
        } else {
            priceSteps = prStepsNode.decimalValue();
        }
        if (prMemNode.isObject()) {
            BigDecimal prMemNumerator = prMemNode.get(NUMERATOR).decimalValue();
            BigDecimal prMemDenominator = prMemNode.get(DENOMINATOR).decimalValue();
            priceMem = prMemNumerator.divide(prMemDenominator);
        } else {
            priceMem = prMemNode.decimalValue();
        }
        JsonNode maxTxExUnitsNode = genesisJson.get(MAX_TX_EX_UNITS);
        BigInteger txExUnitsMem = maxTxExUnitsNode.get(EX_UNITS_MEM).bigIntegerValue();
        BigInteger txExUnitsSteps = maxTxExUnitsNode.get(EX_UNITS_STEPS).bigIntegerValue();
        JsonNode maxBlockExUnitsNode = genesisJson.get(MAX_BLOCK_EX_UNITS);
        BigInteger blockExUnitsMem = maxBlockExUnitsNode.get(EX_UNITS_MEM).bigIntegerValue();
        BigInteger blockExUnitsStep = maxBlockExUnitsNode.get(EX_UNITS_STEPS).bigIntegerValue();
        long maxValueSize = genesisJson.get(MAX_VALUE_SIZE).asLong();
        int collateralPercentage = genesisJson.get(COLLATERAL_PERCENTAGE).asInt();
        int maxCollateralInputs = genesisJson.get(MAX_COLLATERAL_INPUTS).asInt();
        JsonNode costModelNode = genesisJson.get(COST_MODELS);
        JsonNode plutusV1CostModelNode = costModelNode.get("PlutusV1");
        JsonNode plutusV2CostModelNode = costModelNode.get("PlutusV2");
        JsonNode plutusV3CostModelNode = costModelNode.get("PlutusV3");
        long[] plutusV1Costs = this.getCostsInLong(plutusV1CostModelNode);
        long[] plutusV2Costs = plutusV2CostModelNode != null ? this.getCostsInLong(plutusV2CostModelNode) : null;
        long[] plutusV3Costs = plutusV3CostModelNode != null ? this.getCostsInLong(plutusV3CostModelNode) : null;
        HashMap<String, long[]> costModelMap = new HashMap<String, long[]>();
        costModelMap.put("PlutusV1", plutusV1Costs);
        if (plutusV2Costs != null) {
            costModelMap.put("PlutusV2", plutusV2Costs);
        }
        if (plutusV3Costs != null) {
            costModelMap.put("PlutusV3", plutusV3Costs);
        }
        this.protocolParams = ProtocolParams.builder().adaPerUtxoByte(lovelacePerUTxOWord).priceMem(priceMem).priceStep(priceSteps).maxTxExMem(txExUnitsMem).maxTxExSteps(txExUnitsSteps).maxBlockExMem(blockExUnitsMem).maxBlockExSteps(blockExUnitsStep).maxValSize(maxValueSize).collateralPercent(collateralPercentage).maxCollateralInputs(maxCollateralInputs).costModels(costModelMap).costModelsHash("alonzo.genesis").build();
    }

    private long[] getCostsInLong(JsonNode plutusCostModelNode) {
        long[] plutusV1Costs;
        if (plutusCostModelNode.isObject()) {
            Map plutusV1CostModelMap = (Map)this.objectMapper.convertValue((Object)plutusCostModelNode, (TypeReference)new TypeReference<SortedMap<String, Long>>(this){});
            plutusV1Costs = plutusV1CostModelMap.values().stream().mapToLong(Long::longValue).toArray();
        } else if (plutusCostModelNode.isArray()) {
            ArrayNode arrNode = (ArrayNode)plutusCostModelNode;
            plutusV1Costs = new long[arrNode.size()];
            for (int i = 0; i < arrNode.size(); ++i) {
                plutusV1Costs[i] = arrNode.get(i).asLong();
            }
        } else {
            throw new IllegalStateException("CostModel format in alonzo-genesis file isn not supported");
        }
        return plutusV1Costs;
    }

    @Override
    protected String getFileName() {
        return "alonzo-genesis.json";
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlonzoGenesis)) {
            return false;
        }
        AlonzoGenesis other = (AlonzoGenesis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlonzoGenesis;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlonzoGenesis(objectMapper=" + String.valueOf(this.getObjectMapper()) + ")";
    }
}

