/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import com.bloxbean.cardano.client.crypto.Base58;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.exception.StoreRuntimeException;
import com.bloxbean.cardano.yaci.store.common.genesis.AvvmAddressConverter;
import com.bloxbean.cardano.yaci.store.common.genesis.GenesisFile;
import com.bloxbean.cardano.yaci.store.events.GenesisBalance;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ByronGenesis
extends GenesisFile {
    public static final String ATTR_START_TIME = "startTime";
    public static final String ATTR_BLOCK_VERSION_DATA = "blockVersionData";
    public static final String ATTR_SLOT_DURATION = "slotDuration";
    public static final String ATTR_PROTOCOL_CONSTS = "protocolConsts";
    public static final String ATTR_PROTOCOL_MAGIC = "protocolMagic";
    public static final String ATTR_AVVM_DISTR = "avvmDistr";
    public static final String ATTR_NON_AVVM_BALANCES = "nonAvvmBalances";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, BigInteger> avvmDistr;
    private Map<String, BigInteger> nonAvvmBalances;
    private List<GenesisBalance> avvmGenesisBalances;
    private List<GenesisBalance> nonAvvmGenesisBalances;
    private long startTime;
    private long byronSlotLength;
    private long protocolMagic;

    public ByronGenesis(File byronGenesisFile) {
        super(byronGenesisFile);
    }

    public ByronGenesis(InputStream in) {
        super(in);
    }

    public ByronGenesis(long protocolMagic) {
        super(protocolMagic);
    }

    public long getByronSlotLength() {
        if (this.byronSlotLength == 0L) {
            return 0L;
        }
        return this.byronSlotLength / 1000L;
    }

    @Override
    protected void readGenesisData(JsonNode byronJsonNode) {
        this.startTime = byronJsonNode.get(ATTR_START_TIME).asLong();
        this.byronSlotLength = byronJsonNode.get(ATTR_BLOCK_VERSION_DATA).get(ATTR_SLOT_DURATION).asLong() / 1000L;
        this.protocolMagic = byronJsonNode.get(ATTR_PROTOCOL_CONSTS).get(ATTR_PROTOCOL_MAGIC).asLong();
        JsonNode avvmDistrMap = byronJsonNode.get(ATTR_AVVM_DISTR);
        if (avvmDistrMap != null && avvmDistrMap.fields().hasNext()) {
            this.avvmDistr = this.convertAvvmDistribution(avvmDistrMap);
            this.avvmGenesisBalances = this.convertAvvmGenesisBalances(this.avvmDistr);
        } else {
            this.avvmDistr = new HashMap<String, BigInteger>();
            this.avvmGenesisBalances = new ArrayList<GenesisBalance>();
        }
        JsonNode nonAvvmBalancesMap = byronJsonNode.get(ATTR_NON_AVVM_BALANCES);
        if (nonAvvmBalancesMap != null && nonAvvmBalancesMap.fields().hasNext()) {
            this.nonAvvmBalances = this.convertNonAvvmBalances(nonAvvmBalancesMap);
            this.nonAvvmGenesisBalances = this.convertNonAvvmGenesisBalances(this.nonAvvmBalances);
        } else {
            this.nonAvvmBalances = new HashMap<String, BigInteger>();
            this.nonAvvmGenesisBalances = new ArrayList<GenesisBalance>();
        }
    }

    @Override
    protected String getFileName() {
        return "byron-genesis.json";
    }

    private Map<String, BigInteger> convertAvvmDistribution(JsonNode avvmDistrMap) {
        HashMap<String, BigInteger> _avvmDistr = new HashMap<String, BigInteger>();
        avvmDistrMap.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            BigInteger value = new BigInteger(((JsonNode)entry.getValue()).asText());
            _avvmDistr.put(key, value);
        });
        return _avvmDistr;
    }

    private Map<String, BigInteger> convertNonAvvmBalances(JsonNode nonAvvmBalancesMap) {
        HashMap<String, BigInteger> _nonAvvmBalances = new HashMap<String, BigInteger>();
        nonAvvmBalancesMap.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            BigInteger value = new BigInteger(((JsonNode)entry.getValue()).asText());
            _nonAvvmBalances.put(key, value);
        });
        return _nonAvvmBalances;
    }

    private List<GenesisBalance> convertAvvmGenesisBalances(Map<String, BigInteger> avvmBalances) {
        ArrayList<GenesisBalance> avvmGenesisBalances = new ArrayList<GenesisBalance>();
        avvmBalances.entrySet().forEach(entry -> {
            String avvmAddress = (String)entry.getKey();
            BigInteger value = (BigInteger)entry.getValue();
            String byronAddress = AvvmAddressConverter.convertAvvmToByronAddress(avvmAddress).orElseThrow(() -> new StoreRuntimeException("Invalid avvm address"));
            String txHash = HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])Base58.decode((String)byronAddress)));
            GenesisBalance genesisBalance = new GenesisBalance(byronAddress, txHash, value);
            avvmGenesisBalances.add(genesisBalance);
        });
        return avvmGenesisBalances;
    }

    private List<GenesisBalance> convertNonAvvmGenesisBalances(Map<String, BigInteger> nonAvvmBalances) {
        ArrayList<GenesisBalance> nonAvvmGenesisBalances = new ArrayList<GenesisBalance>();
        nonAvvmBalances.entrySet().forEach(entry -> {
            String byronAddress = (String)entry.getKey();
            BigInteger value = (BigInteger)entry.getValue();
            String txHash = HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])Base58.decode((String)byronAddress)));
            GenesisBalance genesisBalance = new GenesisBalance(byronAddress, txHash, value);
            nonAvvmGenesisBalances.add(genesisBalance);
        });
        return nonAvvmGenesisBalances;
    }

    @Generated
    public Map<String, BigInteger> getAvvmDistr() {
        return this.avvmDistr;
    }

    @Generated
    public Map<String, BigInteger> getNonAvvmBalances() {
        return this.nonAvvmBalances;
    }

    @Generated
    public List<GenesisBalance> getAvvmGenesisBalances() {
        return this.avvmGenesisBalances;
    }

    @Generated
    public List<GenesisBalance> getNonAvvmGenesisBalances() {
        return this.nonAvvmGenesisBalances;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getProtocolMagic() {
        return this.protocolMagic;
    }

    @Generated
    public void setAvvmDistr(Map<String, BigInteger> avvmDistr) {
        this.avvmDistr = avvmDistr;
    }

    @Generated
    public void setNonAvvmBalances(Map<String, BigInteger> nonAvvmBalances) {
        this.nonAvvmBalances = nonAvvmBalances;
    }

    @Generated
    public void setAvvmGenesisBalances(List<GenesisBalance> avvmGenesisBalances) {
        this.avvmGenesisBalances = avvmGenesisBalances;
    }

    @Generated
    public void setNonAvvmGenesisBalances(List<GenesisBalance> nonAvvmGenesisBalances) {
        this.nonAvvmGenesisBalances = nonAvvmGenesisBalances;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setByronSlotLength(long byronSlotLength) {
        this.byronSlotLength = byronSlotLength;
    }

    @Generated
    public void setProtocolMagic(long protocolMagic) {
        this.protocolMagic = protocolMagic;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByronGenesis)) {
            return false;
        }
        ByronGenesis other = (ByronGenesis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getByronSlotLength() != other.getByronSlotLength()) {
            return false;
        }
        if (this.getProtocolMagic() != other.getProtocolMagic()) {
            return false;
        }
        Map<String, BigInteger> this$avvmDistr = this.getAvvmDistr();
        Map<String, BigInteger> other$avvmDistr = other.getAvvmDistr();
        if (this$avvmDistr == null ? other$avvmDistr != null : !((Object)this$avvmDistr).equals(other$avvmDistr)) {
            return false;
        }
        Map<String, BigInteger> this$nonAvvmBalances = this.getNonAvvmBalances();
        Map<String, BigInteger> other$nonAvvmBalances = other.getNonAvvmBalances();
        if (this$nonAvvmBalances == null ? other$nonAvvmBalances != null : !((Object)this$nonAvvmBalances).equals(other$nonAvvmBalances)) {
            return false;
        }
        List<GenesisBalance> this$avvmGenesisBalances = this.getAvvmGenesisBalances();
        List<GenesisBalance> other$avvmGenesisBalances = other.getAvvmGenesisBalances();
        if (this$avvmGenesisBalances == null ? other$avvmGenesisBalances != null : !((Object)this$avvmGenesisBalances).equals(other$avvmGenesisBalances)) {
            return false;
        }
        List<GenesisBalance> this$nonAvvmGenesisBalances = this.getNonAvvmGenesisBalances();
        List<GenesisBalance> other$nonAvvmGenesisBalances = other.getNonAvvmGenesisBalances();
        return !(this$nonAvvmGenesisBalances == null ? other$nonAvvmGenesisBalances != null : !((Object)this$nonAvvmGenesisBalances).equals(other$nonAvvmGenesisBalances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ByronGenesis;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $byronSlotLength = this.getByronSlotLength();
        result = result * 59 + (int)($byronSlotLength >>> 32 ^ $byronSlotLength);
        long $protocolMagic = this.getProtocolMagic();
        result = result * 59 + (int)($protocolMagic >>> 32 ^ $protocolMagic);
        Map<String, BigInteger> $avvmDistr = this.getAvvmDistr();
        result = result * 59 + ($avvmDistr == null ? 43 : ((Object)$avvmDistr).hashCode());
        Map<String, BigInteger> $nonAvvmBalances = this.getNonAvvmBalances();
        result = result * 59 + ($nonAvvmBalances == null ? 43 : ((Object)$nonAvvmBalances).hashCode());
        List<GenesisBalance> $avvmGenesisBalances = this.getAvvmGenesisBalances();
        result = result * 59 + ($avvmGenesisBalances == null ? 43 : ((Object)$avvmGenesisBalances).hashCode());
        List<GenesisBalance> $nonAvvmGenesisBalances = this.getNonAvvmGenesisBalances();
        result = result * 59 + ($nonAvvmGenesisBalances == null ? 43 : ((Object)$nonAvvmGenesisBalances).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ByronGenesis(avvmDistr=" + String.valueOf(this.getAvvmDistr()) + ", nonAvvmBalances=" + String.valueOf(this.getNonAvvmBalances()) + ", avvmGenesisBalances=" + String.valueOf(this.getAvvmGenesisBalances()) + ", nonAvvmGenesisBalances=" + String.valueOf(this.getNonAvvmGenesisBalances()) + ", startTime=" + this.getStartTime() + ", byronSlotLength=" + this.getByronSlotLength() + ", protocolMagic=" + this.getProtocolMagic() + ")";
    }
}

