/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import com.bloxbean.cardano.yaci.store.common.domain.DrepVoteThresholds;
import com.bloxbean.cardano.yaci.store.common.domain.GenesisCommitteeMember;
import com.bloxbean.cardano.yaci.store.common.domain.GenesisConstitution;
import com.bloxbean.cardano.yaci.store.common.domain.PoolVotingThresholds;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.genesis.GenesisFile;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ConwayGenesis
extends GenesisFile {
    private static final String POOL_VOTING_THRESHOLDS = "poolVotingThresholds";
    private static final String PVT_COMMITTEE_NORMAL = "committeeNormal";
    private static final String PVT_COMMITTEE_NO_CONFIDENCE = "committeeNoConfidence";
    private static final String PVT_HARD_FORK_INITIATION = "hardForkInitiation";
    private static final String PVT_MOTION_NO_CONFIDENCE = "motionNoConfidence";
    private static final String PVT_PP_SECURITY_GROUP = "ppSecurityGroup";
    private static final String D_REP_VOTING_THRESHOLDS = "dRepVotingThresholds";
    private static final String DVT_MOTION_NO_CONFIDENCE = "motionNoConfidence";
    private static final String DVT_COMMITTEE_NORMAL = "committeeNormal";
    private static final String DVT_COMMITTEE_NO_CONFIDENCE = "committeeNoConfidence";
    private static final String DVT_UPDATE_TO_CONSTITUTION = "updateToConstitution";
    private static final String DVT_HARD_FORK_INITIATION = "hardForkInitiation";
    private static final String DVT_PPNETWORK_GROUP = "ppNetworkGroup";
    private static final String DVT_PPECONOMIC_GROUP = "ppEconomicGroup";
    private static final String DVT_PPTECHNICAL_GROUP = "ppTechnicalGroup";
    private static final String DVT_PPGOV_GROUP = "ppGovGroup";
    private static final String DVT_TREASURY_WITHDRAWAL = "treasuryWithdrawal";
    private static final String COMMITTEE_MIN_SIZE = "committeeMinSize";
    private static final String COMMITTEE_MAX_TERM_LENGTH = "committeeMaxTermLength";
    private static final String GOV_ACTION_LIFETIME = "govActionLifetime";
    private static final String GOV_ACTION_DEPOSIT = "govActionDeposit";
    private static final String D_REP_DEPOSIT = "dRepDeposit";
    private static final String D_REP_ACTIVITY = "dRepActivity";
    private static final String MIN_FEE_REF_SCRIPT_COST_PER_BYTE = "minFeeRefScriptCostPerByte";
    private static final String CONSTITUTION = "constitution";
    private static final String ANCHOR = "anchor";
    private static final String URL = "url";
    private static final String DATA_HASH = "dataHash";
    private static final String SCRIPT = "script";
    private static final String COMMITTEE = "committee";
    private static final String MEMBERS = "members";
    private static final String THRESHOLD = "threshold";
    private static final String NUMERATOR = "numerator";
    private static final String DENOMINATOR = "denominator";
    private static final String PLUTUS_V3_COST_MODEL = "plutusV3CostModel";
    private List<GenesisCommitteeMember> committeeMembers;
    private Double committeeThreshold;
    private BigInteger committeeNumerator;
    private BigInteger committeeDenominator;
    private GenesisConstitution constitution;

    public ConwayGenesis(File file) {
        super(file);
    }

    public ConwayGenesis(InputStream is) {
        super(is);
    }

    public ConwayGenesis(long protocolMagic) {
        super(protocolMagic);
    }

    @Override
    protected void readGenesisData(JsonNode genesisJson) {
        JsonNode constitutionNode;
        JsonNode plutusV3CostModelNode;
        JsonNode committeeMinSizeNode;
        this.committeeMembers = new ArrayList<GenesisCommitteeMember>();
        JsonNode poolVotingThresholdsNode = genesisJson.get(POOL_VOTING_THRESHOLDS);
        PoolVotingThresholds poolVotingThresholds = null;
        if (poolVotingThresholdsNode != null) {
            JsonNode pvtCommitteeNormalNode = poolVotingThresholdsNode.get("committeeNormal");
            BigDecimal pvtCommitteNormal = pvtCommitteeNormalNode.decimalValue();
            JsonNode pvtCommitteeNoConfidenceNode = poolVotingThresholdsNode.get("committeeNoConfidence");
            BigDecimal pvtCommitteeNoConfidence = pvtCommitteeNoConfidenceNode.decimalValue();
            JsonNode pvtHardForkInitiationNode = poolVotingThresholdsNode.get("hardForkInitiation");
            BigDecimal pvtHardForkInitiation = pvtHardForkInitiationNode.decimalValue();
            JsonNode pvtMotionNoConfidenceNode = poolVotingThresholdsNode.get("motionNoConfidence");
            BigDecimal pvtMotionNoConfidence = pvtMotionNoConfidenceNode.decimalValue();
            JsonNode pvtPPSecurityGroup = poolVotingThresholdsNode.get(PVT_PP_SECURITY_GROUP);
            BigDecimal pvtSecurityGroup = pvtPPSecurityGroup.decimalValue();
            poolVotingThresholds = PoolVotingThresholds.builder().pvtCommitteeNormal(pvtCommitteNormal).pvtCommitteeNoConfidence(pvtCommitteeNoConfidence).pvtHardForkInitiation(pvtHardForkInitiation).pvtMotionNoConfidence(pvtMotionNoConfidence).pvtPPSecurityGroup(pvtSecurityGroup).build();
        }
        JsonNode dRepVotingThresholdsNode = genesisJson.get(D_REP_VOTING_THRESHOLDS);
        DrepVoteThresholds drepVoteThresholds = null;
        if (dRepVotingThresholdsNode != null) {
            JsonNode dvtMotionNoConfidenceNode = dRepVotingThresholdsNode.get("motionNoConfidence");
            BigDecimal dvtMotionNoConfidence = dvtMotionNoConfidenceNode.decimalValue();
            JsonNode dvtCommitteeNormalNode = dRepVotingThresholdsNode.get("committeeNormal");
            BigDecimal dvtCommitteeNormal = dvtCommitteeNormalNode.decimalValue();
            JsonNode dvtCommitteeNoConfidenceNode = dRepVotingThresholdsNode.get("committeeNoConfidence");
            BigDecimal dvtCommitteeNoConfidence = dvtCommitteeNoConfidenceNode.decimalValue();
            JsonNode dvtUpdateToConstitutionNode = dRepVotingThresholdsNode.get(DVT_UPDATE_TO_CONSTITUTION);
            BigDecimal dvtUpdateToConstitution = dvtUpdateToConstitutionNode.decimalValue();
            JsonNode dvtHardForkInitiationNode = dRepVotingThresholdsNode.get("hardForkInitiation");
            BigDecimal dvtHardForkInitiation = dvtHardForkInitiationNode.decimalValue();
            JsonNode dvtPPNetworkGroupNode = dRepVotingThresholdsNode.get(DVT_PPNETWORK_GROUP);
            BigDecimal dvtPPNetworkGroup = dvtPPNetworkGroupNode.decimalValue();
            JsonNode dvtPPEconomicGroupNode = dRepVotingThresholdsNode.get(DVT_PPECONOMIC_GROUP);
            BigDecimal dvtPPEconomicGroup = dvtPPEconomicGroupNode.decimalValue();
            JsonNode dvtPPTechnicalGroupNode = dRepVotingThresholdsNode.get(DVT_PPTECHNICAL_GROUP);
            BigDecimal dvtPPTechnicalGroup = dvtPPTechnicalGroupNode.decimalValue();
            JsonNode dvtPPGovGroupNode = dRepVotingThresholdsNode.get(DVT_PPGOV_GROUP);
            BigDecimal dvtPPGovGroup = dvtPPGovGroupNode.decimalValue();
            JsonNode dvtTreasuryWithdrawalNode = dRepVotingThresholdsNode.get(DVT_TREASURY_WITHDRAWAL);
            BigDecimal dvtTreasuryWithdrawal = dvtTreasuryWithdrawalNode.decimalValue();
            drepVoteThresholds = DrepVoteThresholds.builder().dvtMotionNoConfidence(dvtMotionNoConfidence).dvtCommitteeNormal(dvtCommitteeNormal).dvtCommitteeNoConfidence(dvtCommitteeNoConfidence).dvtUpdateToConstitution(dvtUpdateToConstitution).dvtHardForkInitiation(dvtHardForkInitiation).dvtPPNetworkGroup(dvtPPNetworkGroup).dvtPPEconomicGroup(dvtPPEconomicGroup).dvtPPTechnicalGroup(dvtPPTechnicalGroup).dvtPPGovGroup(dvtPPGovGroup).dvtTreasuryWithdrawal(dvtTreasuryWithdrawal).build();
        }
        Integer committeeMinSize = (committeeMinSizeNode = genesisJson.get(COMMITTEE_MIN_SIZE)) != null ? Integer.valueOf(committeeMinSizeNode.asInt()) : null;
        JsonNode committeeMaxTermLengthNode = genesisJson.get(COMMITTEE_MAX_TERM_LENGTH);
        Integer committeeMaxTermLength = committeeMaxTermLengthNode != null ? Integer.valueOf(committeeMaxTermLengthNode.asInt()) : null;
        JsonNode govActionLifetimeNode = genesisJson.get(GOV_ACTION_LIFETIME);
        Integer govActionLifetime = govActionLifetimeNode != null ? Integer.valueOf(govActionLifetimeNode.asInt()) : null;
        JsonNode govActionDepositNode = genesisJson.get(GOV_ACTION_DEPOSIT);
        BigInteger govActionDeposit = govActionDepositNode != null ? govActionDepositNode.bigIntegerValue() : null;
        JsonNode dRepDepositNode = genesisJson.get(D_REP_DEPOSIT);
        BigInteger dRepDeposit = dRepDepositNode != null ? dRepDepositNode.bigIntegerValue() : null;
        JsonNode dRepActivityNode = genesisJson.get(D_REP_ACTIVITY);
        Integer dRepActivity = dRepActivityNode != null ? Integer.valueOf(dRepActivityNode.asInt()) : null;
        JsonNode minFeeRefScriptCostPerByteNode = genesisJson.get(MIN_FEE_REF_SCRIPT_COST_PER_BYTE);
        BigDecimal minFeeRefScriptCostPerByte = minFeeRefScriptCostPerByteNode != null ? minFeeRefScriptCostPerByteNode.decimalValue() : null;
        this.protocolParams = ProtocolParams.builder().poolVotingThresholds(poolVotingThresholds).drepVotingThresholds(drepVoteThresholds).committeeMinSize(committeeMinSize).committeeMaxTermLength(committeeMaxTermLength).govActionLifetime(govActionLifetime).govActionDeposit(govActionDeposit).drepDeposit(dRepDeposit).drepActivity(dRepActivity).minFeeRefScriptCostPerByte(minFeeRefScriptCostPerByte).build();
        JsonNode committeeNode = genesisJson.get(COMMITTEE);
        if (committeeNode != null) {
            JsonNode ccThresholdNode;
            JsonNode membersNode = committeeNode.get(MEMBERS);
            if (membersNode != null) {
                Iterator fields = membersNode.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    String key = (String)field.getKey();
                    Integer expiredEpoch = ((JsonNode)field.getValue()).asInt();
                    Boolean hasScript = key.contains("scriptHash");
                    String hash = key.split("-")[1];
                    GenesisCommitteeMember member = GenesisCommitteeMember.builder().hash(hash).hasScript(hasScript).expiredEpoch(expiredEpoch).build();
                    this.committeeMembers.add(member);
                }
            }
            if ((ccThresholdNode = committeeNode.get(THRESHOLD)) != null) {
                if (ccThresholdNode.isObject()) {
                    JsonNode numeratorNode = ccThresholdNode.get(NUMERATOR);
                    this.committeeNumerator = numeratorNode != null ? numeratorNode.bigIntegerValue() : null;
                    Iterator denominatorNode = ccThresholdNode.get(DENOMINATOR);
                    BigInteger bigInteger = this.committeeDenominator = denominatorNode != null ? denominatorNode.bigIntegerValue() : null;
                    if (this.committeeNumerator != null && this.committeeDenominator != null && this.committeeDenominator.compareTo(BigInteger.ZERO) != 0) {
                        this.committeeThreshold = this.committeeNumerator.doubleValue() / this.committeeDenominator.doubleValue();
                    }
                } else {
                    this.committeeThreshold = ccThresholdNode.decimalValue().doubleValue();
                }
            }
        }
        if ((plutusV3CostModelNode = genesisJson.get(PLUTUS_V3_COST_MODEL)) != null && plutusV3CostModelNode.isArray()) {
            HashMap<String, long[]> costModelMap = new HashMap<String, long[]>();
            ArrayList<Long> costModelList = new ArrayList<Long>();
            for (JsonNode node : plutusV3CostModelNode) {
                costModelList.add(node.longValue());
            }
            long[] plutusV3CostModelArray = costModelList.stream().mapToLong(Long::longValue).toArray();
            costModelMap.put("PlutusV3", plutusV3CostModelArray);
            this.protocolParams.setCostModels(costModelMap);
            this.protocolParams.setCostModelsHash("genesis.conway");
        }
        if ((constitutionNode = genesisJson.get(CONSTITUTION)) != null) {
            String script;
            JsonNode anchorNode = constitutionNode.get(ANCHOR);
            if (anchorNode != null) {
                String anchorUrl = anchorNode.get(URL) != null ? anchorNode.get(URL).asText() : null;
                String anchorHash = anchorNode.get(DATA_HASH) != null ? anchorNode.get(DATA_HASH).asText() : null;
                this.constitution = GenesisConstitution.builder().anchorHash(anchorHash).anchorUrl(anchorUrl).build();
            }
            String string = script = constitutionNode.get(SCRIPT) != null ? constitutionNode.get(SCRIPT).asText() : null;
            if (this.constitution != null) {
                this.constitution.setScript(script);
            }
        }
    }

    @Override
    protected String getFileName() {
        return "conway-genesis.json";
    }

    @Generated
    public List<GenesisCommitteeMember> getCommitteeMembers() {
        return this.committeeMembers;
    }

    @Generated
    public Double getCommitteeThreshold() {
        return this.committeeThreshold;
    }

    @Generated
    public BigInteger getCommitteeNumerator() {
        return this.committeeNumerator;
    }

    @Generated
    public BigInteger getCommitteeDenominator() {
        return this.committeeDenominator;
    }

    @Generated
    public GenesisConstitution getConstitution() {
        return this.constitution;
    }
}

