/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    protected static final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public static String getPrettyJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException var2) {
            log.error("Json parsing error", (Throwable)var2);
            return obj.toString();
        }
    }

    public static String getPrettyJson(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        try {
            Object json = mapper.readValue(jsonStr, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception var2) {
            return jsonStr;
        }
    }

    public static String getJson(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException var2) {
            log.error("Json parsing error", (Throwable)var2);
            return obj.toString();
        }
    }

    public static JsonNode parseJson(String jsonContent) throws JsonProcessingException {
        return mapper.readTree(jsonContent);
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }
}

