/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.genesis;

import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.exception.StoreRuntimeException;
import com.bloxbean.cardano.yaci.store.common.genesis.util.GenesisFileUtil;
import com.bloxbean.cardano.yaci.store.common.util.FileUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenesisFile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenesisFile.class);
    public static final String GENESIS_RESOURCE_FOLDER = "store/networks/";
    protected ProtocolParams protocolParams;
    private ObjectMapper objectMapper = new ObjectMapper();

    public GenesisFile() {
    }

    public GenesisFile(File genesisFile) {
        log.info("Loading genesis file {}", (Object)genesisFile.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(genesisFile);){
            JsonNode jsonNode = this.parseGenesisFile(fis);
            this.readGenesisData(jsonNode);
        }
        catch (IOException e) {
            throw new StoreRuntimeException("Shelley genesis file not found at path : " + String.valueOf(genesisFile));
        }
    }

    public GenesisFile(InputStream is) {
        JsonNode jsonNode = this.parseGenesisFile(is);
        this.readGenesisData(jsonNode);
    }

    public GenesisFile(long protocolMagic) {
        String networkFolder = GenesisFileUtil.getGenesisfileDefaultFolder(protocolMagic);
        if (networkFolder == null) {
            throw new StoreRuntimeException("Genesis files for this network is not found. Please configure through store.cardano.<era>-genesis-file properties.");
        }
        log.info("Loading default genesis files for network : {}", (Object)networkFolder);
        InputStream is = FileUtil.class.getClassLoader().getResourceAsStream(GENESIS_RESOURCE_FOLDER + networkFolder + "/" + this.getFileName());
        JsonNode jsonNode = this.parseGenesisFile(is);
        this.readGenesisData(jsonNode);
    }

    protected abstract void readGenesisData(JsonNode var1);

    protected abstract String getFileName();

    public ProtocolParams getProtocolParams() {
        return this.protocolParams;
    }

    private JsonNode parseGenesisFile(InputStream is) {
        return this.parseJson(is);
    }

    private ObjectNode parseJson(InputStream is) {
        ObjectNode jsonNode;
        try {
            jsonNode = (ObjectNode)this.objectMapper.readTree(is);
        }
        catch (IOException e) {
            throw new StoreRuntimeException("Error parsing shelley genesis file", e);
        }
        return jsonNode;
    }
}

