/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.cache;

import org.h2.mvstore.MVStore;

public class MVStoreFactory {
    private boolean isInitialized = false;
    private MVStore store;

    private MVStoreFactory() {
    }

    public synchronized void init(String dbPath) {
        if (this.isInitialized) {
            throw new IllegalStateException("MVStore is already initialized");
        }
        this.store = new MVStore.Builder().fileName(dbPath).compress().open();
        this.isInitialized = true;
    }

    public MVStore getStore() {
        return this.store;
    }

    public synchronized void close() {
        if (this.store != null && !this.store.isClosed()) {
            this.store.close();
            this.store = null;
        }
    }

    public static MVStoreFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    private static class SingletonHelper {
        private static final MVStoreFactory INSTANCE = new MVStoreFactory();

        private SingletonHelper() {
        }
    }
}

