/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.common.util;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptReferenceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptReferenceUtil.class);

    public static Script deserializeScriptRef(byte[] serializedScriptRef) {
        Array scriptArray = (Array)CborSerializationUtil.deserialize((byte[])serializedScriptRef);
        List dataItemList = scriptArray.getDataItems();
        if (dataItemList == null || dataItemList.size() == 0) {
            throw new CborRuntimeException("Script deserialization failed. Invalid no of DataItem");
        }
        int type = ((UnsignedInteger)dataItemList.get(0)).getValue().intValue();
        try {
            if (type == 0) {
                Array scriptBytes = (Array)dataItemList.get(1);
                return NativeScript.deserialize((Array)scriptBytes);
            }
            if (type == 1) {
                ByteString scriptBytes = (ByteString)dataItemList.get(1);
                return PlutusV1Script.deserialize((ByteString)scriptBytes);
            }
            if (type == 2) {
                ByteString scriptBytes = (ByteString)dataItemList.get(1);
                return PlutusV2Script.deserialize((ByteString)scriptBytes);
            }
            if (type == 3) {
                ByteString scriptBytes = (ByteString)dataItemList.get(1);
                return PlutusV3Script.deserialize((ByteString)scriptBytes);
            }
            throw new CborRuntimeException("Invalid type : " + type);
        }
        catch (Exception e) {
            throw new CborRuntimeException("Script deserialization failed.", e);
        }
    }

    public static String getReferenceScriptHash(byte[] scriptRefBytes) throws CborSerializationException {
        Script script = ScriptReferenceUtil.deserializeScriptRef(scriptRefBytes);
        return HexUtil.encodeHexString((byte[])script.getScriptHash());
    }
}

