/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.epoch.controller;

import com.bloxbean.cardano.yaci.store.api.epoch.controller.LocalEpochController;
import com.bloxbean.cardano.yaci.store.api.epoch.dto.EpochNo;
import com.bloxbean.cardano.yaci.store.api.epoch.service.EpochParamService;
import com.bloxbean.cardano.yaci.store.epoch.dto.ProtocolParamsDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Epoch Service")
@RequestMapping(value={"${apiPrefix}/epochs"})
@ConditionalOnExpression(value="${store.epoch.endpoints.epoch.enabled:true}")
@ConditionalOnMissingBean(value={LocalEpochController.class})
public class EpochController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpochController.class);
    private final EpochParamService epochParamService;

    @PostConstruct
    public void postConstruct() {
        log.info("EpochController initialized >>>");
    }

    @GetMapping(value={"latest/parameters"})
    @Operation(summary="Latest Epoch's Protocol Parameters", description="Get the protocol parameters of the latest epoch.")
    public ProtocolParamsDto getLatestProtocolParams() {
        return this.epochParamService.getLatestProtocolParams().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Protocol params not found"));
    }

    @GetMapping(value={"{number}/parameters"})
    @Operation(summary="Specific Epoch's Protocol Parameters", description="Get the protocol parameters of a specific epoch.")
    public ProtocolParamsDto getProtocolParamsByEpochNo(@PathVariable Integer number) {
        return this.epochParamService.getProtocolParams(number).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Protocol params not found for epoch: " + number));
    }

    @GetMapping(value={"latest"})
    @Operation(summary="Latest Epoch", description="Get latest epoch.")
    public EpochNo getLatestEpoch() {
        return this.epochParamService.getLatestEpoch();
    }

    @Generated
    public EpochController(EpochParamService epochParamService) {
        this.epochParamService = epochParamService;
    }
}

