/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.epoch.controller;

import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.epoch.domain.ProtocolParamsProposal;
import com.bloxbean.cardano.yaci.store.epoch.storage.ProtocolParamsProposalStorageReader;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Network Service")
@RequestMapping(value={"${apiPrefix}/network"})
@ConditionalOnExpression(value="${store.epoch.endpoints.network.enabled:true}")
public class ParamProposalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParamProposalController.class);
    private final ProtocolParamsProposalStorageReader protocolParamsProposalReader;

    @GetMapping(value={"/param-proposals"})
    @Operation(summary="Param Update Proposals", description="Get all parameter update proposals submitted to the chain starting Shelley era.")
    public List<ProtocolParamsProposal> getProtocolParamProposals(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.protocolParamsProposalReader.getProtocolParamsProposals(p, count, Order.desc);
    }

    @Generated
    public ParamProposalController(ProtocolParamsProposalStorageReader protocolParamsProposalReader) {
        this.protocolParamsProposalReader = protocolParamsProposalReader;
    }
}

