/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.epoch.service;

import com.bloxbean.cardano.yaci.store.api.epoch.dto.EpochNo;
import com.bloxbean.cardano.yaci.store.epoch.domain.EpochParam;
import com.bloxbean.cardano.yaci.store.epoch.dto.ProtocolParamsDto;
import com.bloxbean.cardano.yaci.store.epoch.mapper.DomainMapper;
import com.bloxbean.cardano.yaci.store.epoch.storage.EpochParamStorage;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EpochParamService {
    private final EpochParamStorage epochParamStorage;
    private final DomainMapper mapper = DomainMapper.INSTANCE;

    public Optional<ProtocolParamsDto> getLatestProtocolParams() {
        int epoch = this.epochParamStorage.getMaxEpoch();
        return this.epochParamStorage.getProtocolParams(epoch).map(EpochParam::getParams).map(arg_0 -> ((DomainMapper)this.mapper).toProtocolParamsDto(arg_0));
    }

    public Optional<ProtocolParamsDto> getProtocolParams(int epoch) {
        return this.epochParamStorage.getProtocolParams(epoch).map(EpochParam::getParams).map(arg_0 -> ((DomainMapper)this.mapper).toProtocolParamsDto(arg_0));
    }

    public EpochNo getLatestEpoch() {
        Integer latestEpoch = this.epochParamStorage.getMaxEpoch();
        return new EpochNo(latestEpoch.intValue());
    }

    @Generated
    public EpochParamService(EpochParamStorage epochParamStorage) {
        this.epochParamStorage = epochParamStorage;
    }
}

