/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.mapper;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.Special;
import com.bloxbean.cardano.yaci.core.model.ProtocolParamUpdate;
import com.bloxbean.cardano.yaci.core.util.CborSerializationUtil;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.epoch.dto.ProtocolParamsDto;
import com.bloxbean.cardano.yaci.store.epoch.mapper.DomainMapper;
import com.bloxbean.cardano.yaci.store.epoch.util.PlutusOps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DomainMapperDecorator
implements DomainMapper {
    private final DomainMapper delegate;

    public DomainMapperDecorator(DomainMapper delegate) {
        this.delegate = delegate;
    }

    @Override
    public ProtocolParams toProtocolParams(ProtocolParamUpdate protocolParamUpdate) {
        Map<String, long[]> updatedCostModelMap;
        ProtocolParams protocolParams = this.delegate.toProtocolParams(protocolParamUpdate);
        if (protocolParamUpdate.getExtraEntropy() != null) {
            Integer k = (Integer)protocolParamUpdate.getExtraEntropy()._1;
            String v = (String)protocolParamUpdate.getExtraEntropy()._2;
            protocolParams.setExtraEntropy(k + "," + v);
        }
        if ((updatedCostModelMap = this.getCostModels(protocolParamUpdate)) != null && updatedCostModelMap.size() > 0) {
            protocolParams.setCostModels(updatedCostModelMap);
            protocolParams.setCostModelsHash(protocolParams.getCostModelsHash());
        }
        return protocolParams;
    }

    private Map<String, long[]> getCostModels(ProtocolParamUpdate protocolParamUpdate) {
        Map costModelmap = protocolParamUpdate.getCostModels();
        if (costModelmap == null) {
            return null;
        }
        HashMap<String, long[]> resultMap = new HashMap<String, long[]>();
        Set languageKeys = costModelmap.keySet();
        for (Integer key : languageKeys) {
            String strKey = null;
            if (key == 0) {
                strKey = "PlutusV1";
            } else if (key == 1) {
                strKey = "PlutusV2";
            } else if (key == 2) {
                strKey = "PlutusV3";
            }
            String cborCostModelValue = (String)costModelmap.get(key);
            Array array = (Array)CborSerializationUtil.deserializeOne((byte[])HexUtil.decodeHexString((String)cborCostModelValue));
            ArrayList<Long> costs = new ArrayList<Long>();
            for (DataItem di : array.getDataItems()) {
                if (di == Special.BREAK) continue;
                BigInteger val = ((Number)di).getValue();
                costs.add(val.longValue());
            }
            long[] costArray = costs.stream().mapToLong(Long::longValue).toArray();
            resultMap.put(strKey, costArray);
        }
        return resultMap;
    }

    @Override
    public ProtocolParamsDto toProtocolParamsDto(ProtocolParams protocolParams) {
        ProtocolParamsDto protocolParamsDto = this.delegate.toProtocolParamsDto(protocolParams);
        Map costModelMap = protocolParams.getCostModels();
        if (costModelMap == null) {
            return protocolParamsDto;
        }
        if (protocolParamsDto.getCostModels() == null) {
            protocolParamsDto.setCostModels(new TreeMap<String, Map<String, Long>>());
        }
        Iterator iterator = costModelMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            List<Object> ops = switch (key = (String)iterator.next()) {
                case "PlutusV1" -> PlutusOps.getOperations(1);
                case "PlutusV2" -> PlutusOps.getOperations(2);
                case "PlutusV3" -> Collections.emptyList();
                default -> Collections.emptyList();
            };
            TreeMap<String, Long> langCost = new TreeMap<String, Long>();
            long[] costArr = (long[])costModelMap.get(key);
            if (costArr.length == ops.size()) {
                index = 0;
                Object object = ops.iterator();
                while (object.hasNext()) {
                    String op = (String)object.next();
                    langCost.put(op, costArr[index++]);
                }
            } else {
                index = 0;
                for (long opCost : costArr) {
                    langCost.put(String.format("%03d", index++), opCost);
                }
            }
            protocolParamsDto.getCostModels().put(key, langCost);
        }
        return protocolParamsDto;
    }
}

