/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.processor;

import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.util.JsonUtil;
import com.bloxbean.cardano.yaci.store.epoch.domain.EpochParam;
import com.bloxbean.cardano.yaci.store.epoch.domain.ProtocolParamsProposal;
import com.bloxbean.cardano.yaci.store.epoch.processor.EraGenesisProtocolParamsUtil;
import com.bloxbean.cardano.yaci.store.epoch.processor.PPEraChangeRules;
import com.bloxbean.cardano.yaci.store.epoch.storage.EpochParamStorage;
import com.bloxbean.cardano.yaci.store.epoch.storage.ProtocolParamsProposalStorage;
import com.bloxbean.cardano.yaci.store.events.EpochChangeEvent;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EpochParamProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpochParamProcessor.class);
    private final EpochParamStorage epochParamStorage;
    private final ProtocolParamsProposalStorage protocolParamsProposalStorage;
    private final EraGenesisProtocolParamsUtil eraGenesisProtocolParamsUtil;
    private PPEraChangeRules ppEraChangeRules = new PPEraChangeRules();

    @EventListener
    @Transactional
    public void handleEpochChangeEvent(EpochChangeEvent epochChangeEvent) {
        Integer dbEpoch = this.epochParamStorage.getMaxEpoch();
        if (epochChangeEvent.getPreviousEpoch() == null && dbEpoch == epochChangeEvent.getEpoch()) {
            log.info("EpochParam info is already there. Let's ignore it.");
            return;
        }
        int newEpoch = epochChangeEvent.getEpoch();
        if (dbEpoch != null && newEpoch != dbEpoch + 1) {
            log.warn("Some consistency issue. New epoch {}, previously procesed epoch {}", (Object)newEpoch, (Object)dbEpoch);
            return;
        }
        Era prevEra = epochChangeEvent.getPreviousEra();
        Era newEra = epochChangeEvent.getEra();
        Optional<ProtocolParams> genesisProtocolParams = this.eraGenesisProtocolParamsUtil.getGenesisProtocolParameters(newEra, prevEra, epochChangeEvent.getEventMetadata().getProtocolMagic());
        ProtocolParams protocolParams = new ProtocolParams();
        EpochParam previousEpochParam = this.epochParamStorage.getProtocolParams(newEpoch - 1).orElse(null);
        List<ProtocolParamsProposal> ppProposals = this.protocolParamsProposalStorage.getProtocolParamsProposalsByTargetEpoch(newEpoch - 1);
        if (previousEpochParam != null) {
            protocolParams.merge(previousEpochParam.getParams());
        }
        genesisProtocolParams.ifPresent(arg_0 -> ((ProtocolParams)protocolParams).merge(arg_0));
        ppProposals.forEach(ppProposal -> protocolParams.merge(ppProposal.getParams()));
        this.ppEraChangeRules.apply(newEra, prevEra, protocolParams);
        if (log.isDebugEnabled()) {
            log.debug("Final pp: \n " + JsonUtil.getJson((Object)protocolParams));
        }
        BlockAwareDomain epochParam = ((EpochParam.EpochParamBuilder)((EpochParam.EpochParamBuilder)((EpochParam.EpochParamBuilder)((Object)((EpochParam.EpochParamBuilder)((Object)EpochParam.builder().epoch(newEpoch))).params(protocolParams))).slot(epochChangeEvent.getEventMetadata().getSlot()).blockNumber(Long.valueOf(epochChangeEvent.getEventMetadata().getBlock()))).blockTime(epochChangeEvent.getEventMetadata().getBlockTime())).build();
        this.epochParamStorage.save((EpochParam)epochParam);
    }

    @EventListener
    @Transactional
    public void handleRollBack(RollbackEvent rollbackEvent) {
        int count = this.epochParamStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} EpochParam records", (Object)count);
    }

    @Generated
    public EpochParamProcessor(EpochParamStorage epochParamStorage, ProtocolParamsProposalStorage protocolParamsProposalStorage, EraGenesisProtocolParamsUtil eraGenesisProtocolParamsUtil) {
        this.epochParamStorage = epochParamStorage;
        this.protocolParamsProposalStorage = protocolParamsProposalStorage;
        this.eraGenesisProtocolParamsUtil = eraGenesisProtocolParamsUtil;
    }
}

