/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.processor;

import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.store.common.config.StoreProperties;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.genesis.AlonzoGenesis;
import com.bloxbean.cardano.yaci.store.common.genesis.ConwayGenesis;
import com.bloxbean.cardano.yaci.store.common.genesis.ShelleyGenesis;
import com.bloxbean.cardano.yaci.store.common.util.StringUtil;
import com.bloxbean.cardano.yaci.store.epoch.domain.EpochParam;
import com.bloxbean.cardano.yaci.store.epoch.storage.EpochParamStorage;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EraGenesisProtocolParamsUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EraGenesisProtocolParamsUtil.class);
    private final StoreProperties storeProperties;
    private final EpochParamStorage epochParamStorage;

    public Optional<ProtocolParams> getGenesisProtocolParameters(Era newEra, Era prevEra, long protocolMagic) {
        ProtocolParams genesisProtocolParams = null;
        if (newEra != prevEra && newEra != Era.Byron) {
            if (newEra == Era.Shelley) {
                genesisProtocolParams = this.getShelleyGenesisProtocolParams(protocolMagic);
            } else if (newEra == Era.Alonzo) {
                genesisProtocolParams = this.getAlonzoGenesisProtocolParams(protocolMagic);
            } else if (newEra == Era.Babbage) {
                if (prevEra == null) {
                    ProtocolParams shelleyPP = this.getShelleyGenesisProtocolParams(protocolMagic);
                    ProtocolParams alonzoPP = this.getAlonzoGenesisProtocolParams(protocolMagic);
                    genesisProtocolParams = new ProtocolParams();
                    genesisProtocolParams.merge(shelleyPP);
                    genesisProtocolParams.merge(alonzoPP);
                }
            } else if (newEra == Era.Conway) {
                if (prevEra == null) {
                    ProtocolParams shelleyPP = this.getShelleyGenesisProtocolParams(protocolMagic);
                    ProtocolParams alonzoPP = this.getAlonzoGenesisProtocolParams(protocolMagic);
                    ProtocolParams conwayPP = this.getConwayGenesisProtocolParams(protocolMagic);
                    genesisProtocolParams = new ProtocolParams();
                    genesisProtocolParams.merge(shelleyPP);
                    genesisProtocolParams.merge(alonzoPP);
                    genesisProtocolParams.merge(conwayPP);
                } else {
                    genesisProtocolParams = this.getConwayGenesisProtocolParams(protocolMagic);
                    Map ppCostModels = genesisProtocolParams.getCostModels();
                    Integer dbEpoch = this.epochParamStorage.getMaxEpoch();
                    EpochParam previousEpochParam = this.epochParamStorage.getProtocolParams(dbEpoch).orElse(null);
                    if (ppCostModels != null && previousEpochParam != null && previousEpochParam.getParams() != null) {
                        Map ppCostModelsPrev = previousEpochParam.getParams().getCostModels();
                        if (ppCostModelsPrev != null) {
                            ppCostModelsPrev.forEach((k, v) -> {
                                if (!ppCostModels.containsKey(k)) {
                                    ppCostModels.put(k, v);
                                }
                            });
                        }
                        genesisProtocolParams.setCostModels(ppCostModels);
                    }
                }
            } else {
                log.warn("No genesis protocol parameters handled for era {}", (Object)newEra);
            }
        }
        return Optional.ofNullable(genesisProtocolParams);
    }

    private ProtocolParams getShelleyGenesisProtocolParams(long protocolMagic) {
        String shelleyGenesisFile = this.storeProperties.getShelleyGenesisFile();
        if (StringUtil.isEmpty((String)shelleyGenesisFile)) {
            return new ShelleyGenesis(protocolMagic).getProtocolParams();
        }
        return new ShelleyGenesis(new File(shelleyGenesisFile)).getProtocolParams();
    }

    private ProtocolParams getAlonzoGenesisProtocolParams(long protocolMagic) {
        String alonzoGenesisFile = this.storeProperties.getAlonzoGenesisFile();
        if (StringUtil.isEmpty((String)alonzoGenesisFile)) {
            return new AlonzoGenesis(protocolMagic).getProtocolParams();
        }
        return new AlonzoGenesis(new File(alonzoGenesisFile)).getProtocolParams();
    }

    private ProtocolParams getConwayGenesisProtocolParams(long protocolMagic) {
        String conwayGenesisFile = this.storeProperties.getConwayGenesisFile();
        if (StringUtil.isEmpty((String)conwayGenesisFile)) {
            return new ConwayGenesis(protocolMagic).getProtocolParams();
        }
        return new ConwayGenesis(new File(conwayGenesisFile)).getProtocolParams();
    }

    @Generated
    public EraGenesisProtocolParamsUtil(StoreProperties storeProperties, EpochParamStorage epochParamStorage) {
        this.storeProperties = storeProperties;
        this.epochParamStorage = epochParamStorage;
    }
}

