/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.processor;

import com.bloxbean.cardano.yaci.store.common.config.StoreProperties;
import com.bloxbean.cardano.yaci.store.epoch.service.LocalEpochParamService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={LocalEpochParamService.class})
public class LocalEpochParamsScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalEpochParamsScheduler.class);
    private LocalEpochParamService protocolParamService;
    private StoreProperties storeProperties;

    public LocalEpochParamsScheduler(LocalEpochParamService protocolParamService, StoreProperties storeProperties) {
        this.protocolParamService = protocolParamService;
        this.storeProperties = storeProperties;
        if (!storeProperties.isSyncAutoStart()) {
            log.info("Auto sync is disabled. updating epoch param will be ignored");
        }
    }

    @Scheduled(fixedRateString="${store.epoch.n2c-protocol-param-fetching-interval-in-minutes:5}", timeUnit=TimeUnit.MINUTES)
    public void scheduleFetchAndSetCurrentProtocolParams() {
        if (!this.storeProperties.isSyncAutoStart()) {
            return;
        }
        if (this.protocolParamService.getEra() != null) {
            log.info("Fetching protocol params ....");
            this.protocolParamService.fetchAndSetCurrentProtocolParams();
        }
    }
}

