/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.processor;

import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import java.math.BigInteger;
import lombok.NonNull;

class PPEraChangeRules {
    PPEraChangeRules() {
    }

    public void apply(@NonNull Era newEra, Era prevEra, ProtocolParams protocolParams) {
        if (newEra == null) {
            throw new NullPointerException("newEra is marked non-null but is null");
        }
        if (newEra != prevEra) {
            if (newEra == Era.Alonzo) {
                PPEraChangeRules.applyAlonzoRules(protocolParams);
            } else if (newEra == Era.Babbage) {
                if (prevEra == null) {
                    PPEraChangeRules.applyAlonzoRules(protocolParams);
                }
                PPEraChangeRules.applyBabbageRules(protocolParams);
            } else if (newEra == Era.Conway && prevEra == null) {
                PPEraChangeRules.applyAlonzoRules(protocolParams);
                PPEraChangeRules.applyBabbageRules(protocolParams);
            }
        }
    }

    private static void applyAlonzoRules(ProtocolParams protocolParams) {
        protocolParams.setMinUtxo(null);
    }

    private static void applyBabbageRules(ProtocolParams protocolParams) {
        protocolParams.setDecentralisationParam(null);
        protocolParams.setExtraEntropy(null);
        BigInteger utxoPerBytes = protocolParams.getAdaPerUtxoByte().divide(BigInteger.valueOf(8L));
        protocolParams.setAdaPerUtxoByte(utxoPerBytes);
    }
}

