/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.processor;

import com.bloxbean.cardano.yaci.core.model.ProtocolParamUpdate;
import com.bloxbean.cardano.yaci.core.model.Update;
import com.bloxbean.cardano.yaci.store.epoch.domain.ProtocolParamsProposal;
import com.bloxbean.cardano.yaci.store.epoch.mapper.DomainMapper;
import com.bloxbean.cardano.yaci.store.epoch.storage.ProtocolParamsProposalStorage;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.events.UpdateEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProtocolParamsUpdateProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolParamsUpdateProcessor.class);
    private final ProtocolParamsProposalStorage protocolParamsProposalStorage;
    private final DomainMapper mapper = DomainMapper.INSTANCE;

    @EventListener
    @Transactional
    public void handleUpdateEvent(UpdateEvent updateEvent) {
        List txUpdates = updateEvent.getUpdates();
        if (txUpdates == null || txUpdates.size() == 0) {
            return;
        }
        EventMetadata metadata = updateEvent.getMetadata();
        List<ProtocolParamsProposal> protocolParamsProposals = txUpdates.stream().map(txUpdate -> {
            Update update = txUpdate.getUpdate();
            Map ppUpdates = update.getProtocolParamUpdates();
            if (ppUpdates.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            return ppUpdates.entrySet().stream().map(ppEntry -> ((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)((ProtocolParamsProposal.ProtocolParamsProposalBuilder)((Object)((Object)((Object)ProtocolParamsProposal.builder().txHash(txUpdate.getTxHash()))))).keyHash((String)ppEntry.getKey()))))).params(this.mapper.toProtocolParams((ProtocolParamUpdate)ppEntry.getValue())))))).targetEpoch((int)update.getEpoch()))))).epoch(metadata.getEpochNumber()))))).slot(metadata.getSlot()))))).era(metadata.getEra()).blockNumber(Long.valueOf(metadata.getBlock()))).blockTime(metadata.getBlockTime())).build()).toList();
        }).filter(list -> !list.isEmpty()).flatMap(Collection::stream).toList();
        if (!protocolParamsProposals.isEmpty()) {
            this.protocolParamsProposalStorage.saveAll(protocolParamsProposals);
        }
    }

    @EventListener
    @Transactional
    public void handleRollback(RollbackEvent rollbackEvent) {
        int count = this.protocolParamsProposalStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} ProtocolParamsProposal records", (Object)count);
    }

    @Generated
    public ProtocolParamsUpdateProcessor(ProtocolParamsProposalStorage protocolParamsProposalStorage) {
        this.protocolParamsProposalStorage = protocolParamsProposalStorage;
    }
}

