/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.service;

import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.core.model.ProtocolParamUpdate;
import com.bloxbean.cardano.yaci.core.protocol.localstate.api.Query;
import com.bloxbean.cardano.yaci.core.protocol.localstate.queries.CurrentProtocolParamQueryResult;
import com.bloxbean.cardano.yaci.core.protocol.localstate.queries.CurrentProtocolParamsQuery;
import com.bloxbean.cardano.yaci.helper.LocalClientProvider;
import com.bloxbean.cardano.yaci.helper.LocalStateQueryClient;
import com.bloxbean.cardano.yaci.store.common.domain.ProtocolParams;
import com.bloxbean.cardano.yaci.store.common.util.Tuple;
import com.bloxbean.cardano.yaci.store.core.annotation.LocalSupport;
import com.bloxbean.cardano.yaci.store.core.annotation.ReadOnly;
import com.bloxbean.cardano.yaci.store.core.service.EraService;
import com.bloxbean.cardano.yaci.store.core.service.local.LocalClientProviderManager;
import com.bloxbean.cardano.yaci.store.epoch.annotation.LocalEpochParam;
import com.bloxbean.cardano.yaci.store.epoch.domain.EpochParam;
import com.bloxbean.cardano.yaci.store.epoch.mapper.DomainMapper;
import com.bloxbean.cardano.yaci.store.epoch.storage.LocalEpochParamsStorage;
import com.bloxbean.cardano.yaci.store.events.BlockHeaderEvent;
import com.bloxbean.cardano.yaci.store.events.EpochChangeEvent;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@LocalSupport
@LocalEpochParam
@ReadOnly(value=false)
public class LocalEpochParamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalEpochParamService.class);
    private final LocalClientProviderManager localClientProviderManager;
    private final EraService eraService;
    private final LocalEpochParamsStorage localProtocolParamsStorage;
    private DomainMapper domainMapper = DomainMapper.INSTANCE;
    private com.bloxbean.cardano.yaci.core.protocol.localstate.api.Era era;

    public LocalEpochParamService(LocalClientProviderManager localClientProviderManager, LocalEpochParamsStorage localProtocolParamsStorage, EraService eraService) {
        this.localClientProviderManager = localClientProviderManager;
        this.localProtocolParamsStorage = localProtocolParamsStorage;
        this.eraService = eraService;
        log.info("ProtocolParamService initialized >>>");
    }

    @EventListener
    public void blockEvent(BlockHeaderEvent blockHeaderEvent) {
        if (!(blockHeaderEvent.getMetadata().getEra() == null || blockHeaderEvent.getMetadata().getEra().value < Era.Shelley.value || this.era != null && blockHeaderEvent.getMetadata().getEra().name().equalsIgnoreCase(this.era.name()))) {
            this.era = com.bloxbean.cardano.yaci.core.protocol.localstate.api.Era.valueOf((String)blockHeaderEvent.getMetadata().getEra().name());
            log.info("Current era: {}", (Object)this.era.name());
            log.info("Fetching protocol params ...");
            this.fetchAndSetCurrentProtocolParams();
        }
    }

    @EventListener
    public void epochEvent(EpochChangeEvent epochChangeEvent) {
        if (!epochChangeEvent.getEventMetadata().isSyncMode()) {
            return;
        }
        this.era = com.bloxbean.cardano.yaci.core.protocol.localstate.api.Era.valueOf((String)epochChangeEvent.getEra().name());
        log.info("Epoch change event received. Fetching protocol params ...");
        this.fetchAndSetCurrentProtocolParams();
    }

    public synchronized void fetchAndSetCurrentProtocolParams() {
        Optional epochAndTip = this.eraService.getTipAndCurrentEpoch();
        if (epochAndTip.isEmpty()) {
            log.error("Epoch is null. Cannot fetch protocol params");
            return;
        }
        Integer epoch = (Integer)((Tuple)epochAndTip.get())._2;
        Optional localClientProvider = this.localClientProviderManager.getLocalClientProvider();
        try {
            LocalStateQueryClient localStateQueryClient = localClientProvider.map(LocalClientProvider::getLocalStateQueryClient).orElse(null);
            if (localStateQueryClient == null) {
                log.info("LocalStateQueryClient is not initialized. Please check if n2c-node-socket-path or n2c-host is configured properly.");
                return;
            }
            try {
                localStateQueryClient.release().block(Duration.ofSeconds(5L));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                localStateQueryClient.acquire().block(Duration.ofSeconds(5L));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Mono mono = localStateQueryClient.executeQuery((Query)new CurrentProtocolParamsQuery(this.era));
            mono.map(CurrentProtocolParamQueryResult::getProtocolParams).doOnError(throwable -> log.error("Protocol param sync error {}", (Object)throwable.getMessage())).doFinally(signalType -> this.localClientProviderManager.close((LocalClientProvider)localClientProvider.get())).subscribe(protocolParamUpdate -> {
                EpochParam epochParam = new EpochParam();
                epochParam.setEpoch(epoch);
                epochParam.setParams(this.convertProtoParams((ProtocolParamUpdate)protocolParamUpdate));
                this.localProtocolParamsStorage.save(epochParam);
            });
        }
        catch (Exception e) {
            this.localClientProviderManager.close((LocalClientProvider)localClientProvider.get());
        }
    }

    public Optional<ProtocolParams> getCurrentProtocolParams() {
        return this.localProtocolParamsStorage.getLatestEpochParam().map(EpochParam::getParams);
    }

    public Optional<ProtocolParams> getProtocolParams(int epoch) {
        return this.localProtocolParamsStorage.getEpochParam(epoch).map(EpochParam::getParams);
    }

    public Optional<Integer> getMaxEpoch() {
        return this.localProtocolParamsStorage.getMaxEpoch();
    }

    private ProtocolParams convertProtoParams(ProtocolParamUpdate protocolParamUpdate) {
        return this.domainMapper.toProtocolParams(protocolParamUpdate);
    }

    @Generated
    public com.bloxbean.cardano.yaci.core.protocol.localstate.api.Era getEra() {
        return this.era;
    }
}

