/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.epoch.storage.impl;

import com.bloxbean.cardano.yaci.store.common.model.BlockAwareEntity;
import com.bloxbean.cardano.yaci.store.epoch.domain.EpochParam;
import com.bloxbean.cardano.yaci.store.epoch.storage.EpochParamStorage;
import com.bloxbean.cardano.yaci.store.epoch.storage.impl.mapper.ProtocolParamsMapper;
import com.bloxbean.cardano.yaci.store.epoch.storage.impl.model.CostModelEntity;
import com.bloxbean.cardano.yaci.store.epoch.storage.impl.model.EpochParamEntity;
import com.bloxbean.cardano.yaci.store.epoch.storage.impl.repository.CostModelRepository;
import com.bloxbean.cardano.yaci.store.epoch.storage.impl.repository.EpochParamRepository;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpochParamStorageImpl
implements EpochParamStorage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpochParamStorageImpl.class);
    private final EpochParamRepository epochParamRepository;
    private final CostModelRepository costModelRepository;
    private final ProtocolParamsMapper mapper;

    @Override
    public void save(EpochParam epochParam) {
        boolean costModelExists;
        if (epochParam == null) {
            return;
        }
        this.epochParamRepository.findById(epochParam.getEpoch()).ifPresent(epochParamEntity -> this.epochParamRepository.delete(epochParamEntity));
        EpochParamEntity entity = this.mapper.toEntity(epochParam);
        Map costModels = epochParam.getParams().getCostModels();
        String costModelHash = epochParam.getParams().getCostModelsHash();
        if (costModelHash != null && costModels != null && !(costModelExists = this.costModelRepository.existsById(costModelHash))) {
            BlockAwareEntity costModelEntity = ((CostModelEntity.CostModelEntityBuilder)((CostModelEntity.CostModelEntityBuilder)((CostModelEntity.CostModelEntityBuilder)((Object)((CostModelEntity.CostModelEntityBuilder)((Object)CostModelEntity.builder().costs(costModels))).hash(costModelHash))).slot(epochParam.getSlot()).blockNumber(epochParam.getBlockNumber())).blockTime(epochParam.getBlockTime())).build();
            this.costModelRepository.save(costModelEntity);
        }
        this.epochParamRepository.save((Object)entity);
    }

    @Override
    public Optional<EpochParam> getProtocolParams(int epoch) {
        Optional<EpochParam> epochParamOpt = this.epochParamRepository.findById(epoch).map(this.mapper::toDomain);
        Map costs = epochParamOpt.map(epochParam -> epochParam.getParams().getCostModelsHash()).filter(costModelHash -> costModelHash != null).map(costModelHash -> this.costModelRepository.findById(costModelHash)).map(costModelEntity -> ((CostModelEntity)((Object)((Object)costModelEntity.get()))).getCosts()).orElse(null);
        epochParamOpt.ifPresent(epochParam -> epochParam.getParams().setCostModels(costs));
        return epochParamOpt;
    }

    @Override
    public Integer getMaxEpoch() {
        return this.epochParamRepository.findMaxEpoch();
    }

    @Override
    public int deleteBySlotGreaterThan(long slot) {
        return this.epochParamRepository.deleteBySlotGreaterThan(slot);
    }

    @Generated
    public EpochParamStorageImpl(EpochParamRepository epochParamRepository, CostModelRepository costModelRepository, ProtocolParamsMapper mapper) {
        this.epochParamRepository = epochParamRepository;
        this.costModelRepository = costModelRepository;
        this.mapper = mapper;
    }
}

