/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.events;

import com.bloxbean.cardano.yaci.core.model.Era;
import com.bloxbean.cardano.yaci.store.events.GenesisBalance;
import java.util.List;

public class GenesisBlockEvent {
    private String blockHash;
    private long blockTime;
    private long block;
    private long slot;
    private Era era;
    private List<GenesisBalance> genesisBalances;
    private boolean remotePublish;

    public static GenesisBlockEventBuilder builder() {
        return new GenesisBlockEventBuilder();
    }

    public GenesisBlockEventBuilder toBuilder() {
        return new GenesisBlockEventBuilder().blockHash(this.blockHash).blockTime(this.blockTime).block(this.block).slot(this.slot).era(this.era).genesisBalances(this.genesisBalances).remotePublish(this.remotePublish);
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public long getBlock() {
        return this.block;
    }

    public long getSlot() {
        return this.slot;
    }

    public Era getEra() {
        return this.era;
    }

    public List<GenesisBalance> getGenesisBalances() {
        return this.genesisBalances;
    }

    public boolean isRemotePublish() {
        return this.remotePublish;
    }

    public GenesisBlockEvent() {
    }

    public GenesisBlockEvent(String blockHash, long blockTime, long block, long slot, Era era, List<GenesisBalance> genesisBalances, boolean remotePublish) {
        this.blockHash = blockHash;
        this.blockTime = blockTime;
        this.block = block;
        this.slot = slot;
        this.era = era;
        this.genesisBalances = genesisBalances;
        this.remotePublish = remotePublish;
    }

    public static class GenesisBlockEventBuilder {
        private String blockHash;
        private long blockTime;
        private long block;
        private long slot;
        private Era era;
        private List<GenesisBalance> genesisBalances;
        private boolean remotePublish;

        GenesisBlockEventBuilder() {
        }

        public GenesisBlockEventBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public GenesisBlockEventBuilder blockTime(long blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public GenesisBlockEventBuilder block(long block) {
            this.block = block;
            return this;
        }

        public GenesisBlockEventBuilder slot(long slot) {
            this.slot = slot;
            return this;
        }

        public GenesisBlockEventBuilder era(Era era) {
            this.era = era;
            return this;
        }

        public GenesisBlockEventBuilder genesisBalances(List<GenesisBalance> genesisBalances) {
            this.genesisBalances = genesisBalances;
            return this;
        }

        public GenesisBlockEventBuilder remotePublish(boolean remotePublish) {
            this.remotePublish = remotePublish;
            return this;
        }

        public GenesisBlockEvent build() {
            return new GenesisBlockEvent(this.blockHash, this.blockTime, this.block, this.slot, this.era, this.genesisBalances, this.remotePublish);
        }

        public String toString() {
            return "GenesisBlockEvent.GenesisBlockEventBuilder(blockHash=" + this.blockHash + ", blockTime=" + this.blockTime + ", block=" + this.block + ", slot=" + this.slot + ", era=" + this.era + ", genesisBalances=" + this.genesisBalances + ", remotePublish=" + this.remotePublish + ")";
        }
    }
}

