/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.events;

import com.bloxbean.cardano.yaci.core.model.Era;

public class EventMetadata {
    private boolean mainnet;
    private long protocolMagic;
    private Era era;
    private String slotLeader;
    private int epochNumber;
    private long block;
    private String blockHash;
    private long blockTime;
    private String prevBlockHash;
    private long slot;
    private long epochSlot;
    private int noOfTxs;
    private boolean syncMode;
    private boolean parallelMode;
    private boolean remotePublish;

    public static EventMetadataBuilder builder() {
        return new EventMetadataBuilder();
    }

    public EventMetadataBuilder toBuilder() {
        return new EventMetadataBuilder().mainnet(this.mainnet).protocolMagic(this.protocolMagic).era(this.era).slotLeader(this.slotLeader).epochNumber(this.epochNumber).block(this.block).blockHash(this.blockHash).blockTime(this.blockTime).prevBlockHash(this.prevBlockHash).slot(this.slot).epochSlot(this.epochSlot).noOfTxs(this.noOfTxs).syncMode(this.syncMode).parallelMode(this.parallelMode).remotePublish(this.remotePublish);
    }

    public boolean isMainnet() {
        return this.mainnet;
    }

    public long getProtocolMagic() {
        return this.protocolMagic;
    }

    public Era getEra() {
        return this.era;
    }

    public String getSlotLeader() {
        return this.slotLeader;
    }

    public int getEpochNumber() {
        return this.epochNumber;
    }

    public long getBlock() {
        return this.block;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public String getPrevBlockHash() {
        return this.prevBlockHash;
    }

    public long getSlot() {
        return this.slot;
    }

    public long getEpochSlot() {
        return this.epochSlot;
    }

    public int getNoOfTxs() {
        return this.noOfTxs;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public boolean isParallelMode() {
        return this.parallelMode;
    }

    public boolean isRemotePublish() {
        return this.remotePublish;
    }

    public EventMetadata() {
    }

    public EventMetadata(boolean mainnet, long protocolMagic, Era era, String slotLeader, int epochNumber, long block, String blockHash, long blockTime, String prevBlockHash, long slot, long epochSlot, int noOfTxs, boolean syncMode, boolean parallelMode, boolean remotePublish) {
        this.mainnet = mainnet;
        this.protocolMagic = protocolMagic;
        this.era = era;
        this.slotLeader = slotLeader;
        this.epochNumber = epochNumber;
        this.block = block;
        this.blockHash = blockHash;
        this.blockTime = blockTime;
        this.prevBlockHash = prevBlockHash;
        this.slot = slot;
        this.epochSlot = epochSlot;
        this.noOfTxs = noOfTxs;
        this.syncMode = syncMode;
        this.parallelMode = parallelMode;
        this.remotePublish = remotePublish;
    }

    public String toString() {
        return "EventMetadata(mainnet=" + this.isMainnet() + ", protocolMagic=" + this.getProtocolMagic() + ", era=" + String.valueOf(this.getEra()) + ", slotLeader=" + this.getSlotLeader() + ", epochNumber=" + this.getEpochNumber() + ", block=" + this.getBlock() + ", blockHash=" + this.getBlockHash() + ", blockTime=" + this.getBlockTime() + ", prevBlockHash=" + this.getPrevBlockHash() + ", slot=" + this.getSlot() + ", epochSlot=" + this.getEpochSlot() + ", noOfTxs=" + this.getNoOfTxs() + ", syncMode=" + this.isSyncMode() + ", parallelMode=" + this.isParallelMode() + ", remotePublish=" + this.isRemotePublish() + ")";
    }

    public static class EventMetadataBuilder {
        private boolean mainnet;
        private long protocolMagic;
        private Era era;
        private String slotLeader;
        private int epochNumber;
        private long block;
        private String blockHash;
        private long blockTime;
        private String prevBlockHash;
        private long slot;
        private long epochSlot;
        private int noOfTxs;
        private boolean syncMode;
        private boolean parallelMode;
        private boolean remotePublish;

        EventMetadataBuilder() {
        }

        public EventMetadataBuilder mainnet(boolean mainnet) {
            this.mainnet = mainnet;
            return this;
        }

        public EventMetadataBuilder protocolMagic(long protocolMagic) {
            this.protocolMagic = protocolMagic;
            return this;
        }

        public EventMetadataBuilder era(Era era) {
            this.era = era;
            return this;
        }

        public EventMetadataBuilder slotLeader(String slotLeader) {
            this.slotLeader = slotLeader;
            return this;
        }

        public EventMetadataBuilder epochNumber(int epochNumber) {
            this.epochNumber = epochNumber;
            return this;
        }

        public EventMetadataBuilder block(long block) {
            this.block = block;
            return this;
        }

        public EventMetadataBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public EventMetadataBuilder blockTime(long blockTime) {
            this.blockTime = blockTime;
            return this;
        }

        public EventMetadataBuilder prevBlockHash(String prevBlockHash) {
            this.prevBlockHash = prevBlockHash;
            return this;
        }

        public EventMetadataBuilder slot(long slot) {
            this.slot = slot;
            return this;
        }

        public EventMetadataBuilder epochSlot(long epochSlot) {
            this.epochSlot = epochSlot;
            return this;
        }

        public EventMetadataBuilder noOfTxs(int noOfTxs) {
            this.noOfTxs = noOfTxs;
            return this;
        }

        public EventMetadataBuilder syncMode(boolean syncMode) {
            this.syncMode = syncMode;
            return this;
        }

        public EventMetadataBuilder parallelMode(boolean parallelMode) {
            this.parallelMode = parallelMode;
            return this;
        }

        public EventMetadataBuilder remotePublish(boolean remotePublish) {
            this.remotePublish = remotePublish;
            return this;
        }

        public EventMetadata build() {
            return new EventMetadata(this.mainnet, this.protocolMagic, this.era, this.slotLeader, this.epochNumber, this.block, this.blockHash, this.blockTime, this.prevBlockHash, this.slot, this.epochSlot, this.noOfTxs, this.syncMode, this.parallelMode, this.remotePublish);
        }

        public String toString() {
            return "EventMetadata.EventMetadataBuilder(mainnet=" + this.mainnet + ", protocolMagic=" + this.protocolMagic + ", era=" + String.valueOf(this.era) + ", slotLeader=" + this.slotLeader + ", epochNumber=" + this.epochNumber + ", block=" + this.block + ", blockHash=" + this.blockHash + ", blockTime=" + this.blockTime + ", prevBlockHash=" + this.prevBlockHash + ", slot=" + this.slot + ", epochSlot=" + this.epochSlot + ", noOfTxs=" + this.noOfTxs + ", syncMode=" + this.syncMode + ", parallelMode=" + this.parallelMode + ", remotePublish=" + this.remotePublish + ")";
        }
    }
}

