/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.events;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;

public class RollbackEvent {
    private Point rollbackTo;
    private Point currentPoint;
    private long currentBlock;
    private boolean remotePublish;

    public static RollbackEventBuilder builder() {
        return new RollbackEventBuilder();
    }

    public RollbackEventBuilder toBuilder() {
        return new RollbackEventBuilder().rollbackTo(this.rollbackTo).currentPoint(this.currentPoint).currentBlock(this.currentBlock).remotePublish(this.remotePublish);
    }

    public Point getRollbackTo() {
        return this.rollbackTo;
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public long getCurrentBlock() {
        return this.currentBlock;
    }

    public boolean isRemotePublish() {
        return this.remotePublish;
    }

    public RollbackEvent(Point rollbackTo, Point currentPoint, long currentBlock, boolean remotePublish) {
        this.rollbackTo = rollbackTo;
        this.currentPoint = currentPoint;
        this.currentBlock = currentBlock;
        this.remotePublish = remotePublish;
    }

    public RollbackEvent() {
    }

    public String toString() {
        return "RollbackEvent(rollbackTo=" + String.valueOf(this.getRollbackTo()) + ", currentPoint=" + String.valueOf(this.getCurrentPoint()) + ", currentBlock=" + this.getCurrentBlock() + ", remotePublish=" + this.isRemotePublish() + ")";
    }

    public static class RollbackEventBuilder {
        private Point rollbackTo;
        private Point currentPoint;
        private long currentBlock;
        private boolean remotePublish;

        RollbackEventBuilder() {
        }

        public RollbackEventBuilder rollbackTo(Point rollbackTo) {
            this.rollbackTo = rollbackTo;
            return this;
        }

        public RollbackEventBuilder currentPoint(Point currentPoint) {
            this.currentPoint = currentPoint;
            return this;
        }

        public RollbackEventBuilder currentBlock(long currentBlock) {
            this.currentBlock = currentBlock;
            return this;
        }

        public RollbackEventBuilder remotePublish(boolean remotePublish) {
            this.remotePublish = remotePublish;
            return this;
        }

        public RollbackEvent build() {
            return new RollbackEvent(this.rollbackTo, this.currentPoint, this.currentBlock, this.remotePublish);
        }

        public String toString() {
            return "RollbackEvent.RollbackEventBuilder(rollbackTo=" + String.valueOf(this.rollbackTo) + ", currentPoint=" + String.valueOf(this.currentPoint) + ", currentBlock=" + this.currentBlock + ", remotePublish=" + this.remotePublish + ")";
        }
    }
}

