/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.metadata.controller;

import com.bloxbean.cardano.yaci.store.api.metadata.dto.MetadataDtoMapper;
import com.bloxbean.cardano.yaci.store.api.metadata.dto.MetadataLabelDto;
import com.bloxbean.cardano.yaci.store.api.metadata.dto.TxMetadataLabelCBORDto;
import com.bloxbean.cardano.yaci.store.api.metadata.dto.TxMetadataLabelDto;
import com.bloxbean.cardano.yaci.store.api.metadata.service.MetadataService;
import com.bloxbean.cardano.yaci.store.metadata.domain.TxMetadataLabel;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${apiPrefix}"})
@Tag(name="Transaction Service")
@ConditionalOnExpression(value="${store.metadata.endpoints.transaction.enabled:true}")
public class MetadataController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataController.class);
    private final MetadataService metadataService;
    private final MetadataDtoMapper metadataDtoMapper;

    @GetMapping(value={"/txs/{txHash}/metadata"})
    @Operation(summary="Transaction Metadata Labels", description="Get a list of metadata labels included in a specific transaction.")
    public List<TxMetadataLabelDto> getMetadataByTxHash(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash) {
        List<TxMetadataLabel> txMetadataLabels = this.metadataService.getMetadataForTx(txHash);
        if (txMetadataLabels == null || txMetadataLabels.isEmpty()) {
            return Collections.emptyList();
        }
        return txMetadataLabels.stream().map(this.metadataDtoMapper::toTxMetadataLabelDto).toList();
    }

    @GetMapping(value={"/txs/{txHash}/metadata/cbor"})
    @Operation(summary="Transaction Metadata CBOR", description="Get a list of metadata CBOR included in a specific transaction.")
    public List<TxMetadataLabelCBORDto> getMetadataCborByTxHash(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash) {
        List<TxMetadataLabel> txMetadataLabels = this.metadataService.getMetadataForTx(txHash);
        if (txMetadataLabels == null || txMetadataLabels.isEmpty()) {
            return Collections.emptyList();
        }
        return txMetadataLabels.stream().map(this.metadataDtoMapper::toTxMetadataLabelCBORDto).toList();
    }

    @GetMapping(value={"/txs/metadata/labels/{label}"})
    @Operation(summary="Metadata Labels", description="Get a list of metadata Label included by a specific label.")
    public List<MetadataLabelDto> getMetadataByLabel(@PathVariable String label, @RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.metadataService.getMetadataByLabel(label, p, count).stream().map(this.metadataDtoMapper::toMetadataLabelDto).toList();
    }

    @Generated
    public MetadataController(MetadataService metadataService, MetadataDtoMapper metadataDtoMapper) {
        this.metadataService = metadataService;
        this.metadataDtoMapper = metadataDtoMapper;
    }
}

