/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.starter.core;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.BlockRangeSync;
import com.bloxbean.cardano.yaci.helper.BlockSync;
import com.bloxbean.cardano.yaci.helper.GenesisBlockFinder;
import com.bloxbean.cardano.yaci.helper.LocalClientProvider;
import com.bloxbean.cardano.yaci.helper.TipFinder;
import com.bloxbean.cardano.yaci.store.client.utxo.DummyUtxoClient;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClientImpl;
import com.bloxbean.cardano.yaci.store.core.StoreConfiguration;
import com.bloxbean.cardano.yaci.store.core.StoreProperties;
import com.bloxbean.cardano.yaci.store.core.service.ApplicationStartListener;
import com.bloxbean.cardano.yaci.store.starter.core.YaciStoreProperties;
import org.jooq.conf.RenderQuotedNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jooq.DefaultConfigurationCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={YaciStoreProperties.class})
@ComponentScan(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EnableJpaRepositories(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EntityScan(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EnableTransactionManagement
@EnableScheduling
@Import(value={StoreConfiguration.class})
public class YaciStoreAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YaciStoreAutoConfiguration.class);
    @Autowired
    YaciStoreProperties properties;

    @Bean
    public TipFinder tipFinder() {
        TipFinder tipFinder = new TipFinder(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), Point.ORIGIN, this.properties.getCardano().getProtocolMagic());
        tipFinder.start();
        return tipFinder;
    }

    @Bean
    @Scope(value="prototype")
    public BlockRangeSync blockRangeSync() {
        log.info("Creating BlockRangeSync to fetch blocks");
        BlockRangeSync blockRangeSync = new BlockRangeSync(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic());
        return blockRangeSync;
    }

    @Bean
    public BlockSync blockSync() {
        BlockSync blockSync = new BlockSync(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic(), Point.ORIGIN);
        return blockSync;
    }

    @Bean
    public GenesisBlockFinder genesisBlockFinder() {
        GenesisBlockFinder genesisBlockFinder = new GenesisBlockFinder(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic());
        return genesisBlockFinder;
    }

    @Bean(name={"localClientProvider"})
    @ConditionalOnProperty(prefix="store.cardano", name={"n2c-node-socket-path"})
    @Primary
    public LocalClientProvider localClientProviderNodeSocketPath() {
        log.info("LocalStateQueryClient ---> Configured --> " + this.properties.getCardano().getN2cNodeSocketPath());
        return new LocalClientProvider(this.properties.getCardano().getN2cNodeSocketPath(), this.properties.getCardano().getProtocolMagic());
    }

    @Bean(name={"localClientProvider"})
    @ConditionalOnProperty(prefix="store.cardano", name={"n2c-host"})
    public LocalClientProvider localClientProviderNodeSocketPort() {
        if (this.properties.getCardano().getN2cPort() == 0) {
            throw new IllegalArgumentException("Invalid cardano.n2c.port " + this.properties.getCardano().getN2cPort());
        }
        log.info("LocalStateQueryClient ---> Configured (n2c host/port)--> " + this.properties.getCardano().getN2cHost() + ", " + this.properties.getCardano().getN2cPort());
        return new LocalClientProvider(this.properties.getCardano().getN2cHost(), this.properties.getCardano().getN2cPort(), this.properties.getCardano().getProtocolMagic());
    }

    @Bean
    @ConditionalOnBean(name={"localClientProvider"})
    public ApplicationStartListener applicationStartListener(LocalClientProvider localClientProvider) {
        log.info("ApplicationStartListener with LocalClientProvider created >>");
        return new ApplicationStartListener(localClientProvider);
    }

    @Bean
    @ConditionalOnMissingBean(name={"utxoClient"})
    public UtxoClient utxoClient(RestTemplate restTemplate) {
        if (this.properties.getUtxoClientUrl() != null && !this.properties.getUtxoClientUrl().isEmpty()) {
            return new UtxoClientImpl(restTemplate, this.properties.getUtxoClientUrl().trim());
        }
        return new DummyUtxoClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public DefaultConfigurationCustomizer configurationCustomiser() {
        return c -> c.settings().withRenderQuotedNames(RenderQuotedNames.NEVER);
    }

    @Bean
    public StoreProperties storeProperties() {
        StoreProperties storeProperties = new StoreProperties();
        storeProperties.setEventPublisherId(Long.valueOf(this.properties.getEventPublisherId()));
        storeProperties.setSyncAutoStart(this.properties.isSyncAutoStart());
        storeProperties.setCardanoHost(this.properties.getCardano().getHost());
        storeProperties.setCardanoPort(this.properties.getCardano().getPort());
        storeProperties.setProtocolMagic(this.properties.getCardano().getProtocolMagic());
        storeProperties.setN2cNodeSocketPath(this.properties.getCardano().getN2cNodeSocketPath());
        storeProperties.setN2cHost(this.properties.getCardano().getN2cHost());
        storeProperties.setN2cPort(this.properties.getCardano().getN2cPort());
        storeProperties.setSubmitApiUrl(this.properties.getCardano().getSubmitApiUrl());
        storeProperties.setOgmiosUrl(this.properties.getCardano().getOgmiosUrl());
        storeProperties.setMempoolMonitoringEnabled(this.properties.getCardano().getMempoolMonitoringEnabled());
        storeProperties.setShelleyStartSlot(this.properties.getCardano().getShelleyStartSlot());
        storeProperties.setShelleyStartBlockhash(this.properties.getCardano().getShelleyStartBlockhash());
        storeProperties.setShelleyStartBlock(this.properties.getCardano().getShelleyStartBlock());
        storeProperties.setSyncStartSlot(this.properties.getCardano().getSyncStartSlot());
        storeProperties.setSyncStartBlockhash(this.properties.getCardano().getSyncStartBlockhash());
        storeProperties.setSyncStartByronBlockNumber(this.properties.getCardano().getSyncStartByronBlockNumber());
        storeProperties.setSyncStopSlot(this.properties.getCardano().getSyncStopSlot());
        storeProperties.setSyncStopBlockhash(this.properties.getCardano().getSyncStopBlockhash());
        storeProperties.setByronGenesisFile(this.properties.getCardano().getByronGenesisFile());
        storeProperties.setShelleyGenesisFile(this.properties.getCardano().getShelleyGenesisFile());
        storeProperties.setBlockDiffToStartSyncProtocol(this.properties.getCardano().getBlockDiffToStartSyncProtocol());
        return storeProperties;
    }
}

