/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.starter.core;

import com.bloxbean.cardano.yaci.core.protocol.chainsync.messages.Point;
import com.bloxbean.cardano.yaci.helper.BlockRangeSync;
import com.bloxbean.cardano.yaci.helper.BlockSync;
import com.bloxbean.cardano.yaci.helper.GenesisBlockFinder;
import com.bloxbean.cardano.yaci.helper.LocalClientProvider;
import com.bloxbean.cardano.yaci.helper.TipFinder;
import com.bloxbean.cardano.yaci.store.client.utxo.DummyUtxoClient;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClientImpl;
import com.bloxbean.cardano.yaci.store.common.config.StoreProperties;
import com.bloxbean.cardano.yaci.store.common.executor.ParallelExecutor;
import com.bloxbean.cardano.yaci.store.core.StoreConfiguration;
import com.bloxbean.cardano.yaci.store.core.annotation.ReadOnly;
import com.bloxbean.cardano.yaci.store.core.service.ApplicationStartListener;
import com.bloxbean.cardano.yaci.store.core.service.BlockFinder;
import com.bloxbean.cardano.yaci.store.core.service.local.LocalClientProviderPoolObjectFactory;
import com.bloxbean.cardano.yaci.store.starter.core.YaciStoreProperties;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jooq.conf.RenderQuotedNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jooq.DefaultConfigurationCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableConfigurationProperties(value={YaciStoreProperties.class})
@ComponentScan(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EnableJpaRepositories(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EntityScan(basePackages={"com.bloxbean.cardano.yaci.store.common", "com.bloxbean.cardano.yaci.store.events"})
@EnableTransactionManagement
@EnableScheduling
@Import(value={StoreConfiguration.class})
public class YaciStoreAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YaciStoreAutoConfiguration.class);
    @Autowired
    YaciStoreProperties properties;

    @Bean
    @ReadOnly(value=false)
    public TipFinder tipFinder() {
        TipFinder tipFinder = new TipFinder(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), Point.ORIGIN, this.properties.getCardano().getProtocolMagic());
        tipFinder.start();
        return tipFinder;
    }

    @Bean
    @ReadOnly(value=false)
    @Scope(value="prototype")
    public BlockRangeSync blockRangeSync() {
        log.info("Creating BlockRangeSync to fetch blocks");
        BlockRangeSync blockRangeSync = new BlockRangeSync(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic());
        return blockRangeSync;
    }

    @Bean
    @ReadOnly(value=false)
    public BlockSync blockSync() {
        BlockSync blockSync = new BlockSync(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic(), Point.ORIGIN);
        return blockSync;
    }

    @Bean
    @ReadOnly(value=false)
    public GenesisBlockFinder genesisBlockFinder() {
        GenesisBlockFinder genesisBlockFinder = new GenesisBlockFinder(this.properties.getCardano().getHost(), this.properties.getCardano().getPort(), this.properties.getCardano().getProtocolMagic());
        return genesisBlockFinder;
    }

    @Bean
    @ReadOnly(value=false)
    public BlockFinder blockFinder(BlockSync blockSync) {
        BlockFinder blockFinder = new BlockFinder(blockSync);
        return blockFinder;
    }

    @Bean(name={"localClientProvider"})
    @ConditionalOnProperty(prefix="store.cardano", name={"n2c-node-socket-path"})
    @Primary
    public LocalClientProvider localClientProviderNodeSocketPath() {
        log.info("LocalStateQueryClient ---> Configured --> " + this.properties.getCardano().getN2cNodeSocketPath());
        return new LocalClientProvider(this.properties.getCardano().getN2cNodeSocketPath(), this.properties.getCardano().getProtocolMagic());
    }

    @Bean(name={"localClientProvider"})
    @ConditionalOnProperty(prefix="store.cardano", name={"n2c-host"})
    public LocalClientProvider localClientProviderNodeSocketPort() {
        if (this.properties.getCardano().getN2cPort() == 0) {
            throw new IllegalArgumentException("Invalid cardano.n2c.port " + this.properties.getCardano().getN2cPort());
        }
        log.info("LocalStateQueryClient ---> Configured (n2c host/port)--> " + this.properties.getCardano().getN2cHost() + ", " + this.properties.getCardano().getN2cPort());
        return new LocalClientProvider(this.properties.getCardano().getN2cHost(), this.properties.getCardano().getN2cPort(), this.properties.getCardano().getProtocolMagic());
    }

    @Bean(name={"localClientProviderPool"})
    @ConditionalOnExpression(value="'${store.cardano.n2c-node-socket-path}' != '' and '${store.cardano.n2c-pool-enabled:false}' == 'true'")
    @Primary
    public GenericObjectPool<LocalClientProvider> localClientProviderPoolSocketPath() {
        LocalClientProviderPoolObjectFactory factory = new LocalClientProviderPoolObjectFactory(this.properties.getCardano().getN2cNodeSocketPath(), this.properties.getCardano().getProtocolMagic());
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.properties.getCardano().getN2cPoolMaxTotal());
        config.setMinIdle(this.properties.getCardano().getN2cPoolMinIdle());
        config.setMaxIdle(this.properties.getCardano().getN2cPoolMaxIdle());
        config.setMaxWait(Duration.ofMillis(this.properties.getCardano().getN2cPoolMaxWaitInMillis()));
        return new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    @Bean(name={"localClientProviderPool"})
    @ConditionalOnExpression(value="'${store.cardano.n2c-host}' != '' and '${store.cardano.n2c-pool-enabled:false}' == 'true'")
    public GenericObjectPool<LocalClientProvider> localClientProviderPoolHost() {
        LocalClientProviderPoolObjectFactory factory = new LocalClientProviderPoolObjectFactory(this.properties.getCardano().getN2cHost(), this.properties.getCardano().getN2cPort(), this.properties.getCardano().getProtocolMagic());
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(this.properties.getCardano().getN2cPoolMaxTotal());
        config.setMinIdle(this.properties.getCardano().getN2cPoolMinIdle());
        config.setMaxIdle(this.properties.getCardano().getN2cPoolMaxIdle());
        config.setMaxWait(Duration.ofMillis(this.properties.getCardano().getN2cPoolMaxWaitInMillis()));
        return new GenericObjectPool((PooledObjectFactory)factory, config);
    }

    @Bean
    @ConditionalOnBean(name={"localClientProvider"})
    public ApplicationStartListener applicationStartListener(LocalClientProvider localClientProvider) {
        log.info("ApplicationStartListener with LocalClientProvider created >>");
        return new ApplicationStartListener(localClientProvider);
    }

    @Bean
    @ConditionalOnMissingBean(name={"utxoClient"})
    public UtxoClient utxoClient(RestTemplate restTemplate) {
        if (this.properties.getUtxoClientUrl() != null && !this.properties.getUtxoClientUrl().isEmpty()) {
            return new UtxoClientImpl(restTemplate, this.properties.getUtxoClientUrl().trim());
        }
        return new DummyUtxoClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public DefaultConfigurationCustomizer configurationCustomiser() {
        return c -> c.settings().withRenderQuotedNames(RenderQuotedNames.NEVER);
    }

    @Bean
    public ParallelExecutor executorHelper() {
        return new ParallelExecutor();
    }

    @Bean
    public StoreProperties storeProperties() {
        StoreProperties storeProperties = new StoreProperties();
        storeProperties.setEventPublisherId(Long.valueOf(this.properties.getEventPublisherId()));
        storeProperties.setSyncAutoStart(this.properties.isSyncAutoStart());
        storeProperties.setReadOnlyMode(this.properties.isReadOnlyMode());
        storeProperties.setCardanoHost(this.properties.getCardano().getHost());
        storeProperties.setCardanoPort(this.properties.getCardano().getPort());
        storeProperties.setProtocolMagic(this.properties.getCardano().getProtocolMagic());
        storeProperties.setN2cNodeSocketPath(this.properties.getCardano().getN2cNodeSocketPath());
        storeProperties.setN2cHost(this.properties.getCardano().getN2cHost());
        storeProperties.setN2cPort(this.properties.getCardano().getN2cPort());
        storeProperties.setSubmitApiUrl(this.properties.getCardano().getSubmitApiUrl());
        storeProperties.setOgmiosUrl(this.properties.getCardano().getOgmiosUrl());
        storeProperties.setMempoolMonitoringEnabled(this.properties.getCardano().getMempoolMonitoringEnabled());
        storeProperties.setShelleyStartSlot(this.properties.getCardano().getShelleyStartSlot());
        storeProperties.setShelleyStartBlockhash(this.properties.getCardano().getShelleyStartBlockhash());
        storeProperties.setShelleyStartBlock(this.properties.getCardano().getShelleyStartBlock());
        storeProperties.setSyncStartSlot(this.properties.getCardano().getSyncStartSlot());
        storeProperties.setSyncStartBlockhash(this.properties.getCardano().getSyncStartBlockhash());
        storeProperties.setSyncStartByronBlockNumber(this.properties.getCardano().getSyncStartByronBlockNumber());
        storeProperties.setSyncStopSlot(this.properties.getCardano().getSyncStopSlot());
        storeProperties.setSyncStopBlockhash(this.properties.getCardano().getSyncStopBlockhash());
        storeProperties.setByronGenesisFile(this.properties.getCardano().getByronGenesisFile());
        storeProperties.setShelleyGenesisFile(this.properties.getCardano().getShelleyGenesisFile());
        storeProperties.setAlonzoGenesisFile(this.properties.getCardano().getAlonzoGenesisFile());
        storeProperties.setConwayGenesisFile(this.properties.getCardano().getConwayGenesisFile());
        storeProperties.setBlockDiffToStartSyncProtocol(this.properties.getCardano().getBlockDiffToStartSyncProtocol());
        storeProperties.setCursorNoOfBlocksToKeep(this.properties.getCardano().getCursorNoOfBlocksToKeep());
        storeProperties.setCursorCleanupInterval(this.properties.getCardano().getCursorCleanupInterval());
        storeProperties.setKeepAliveInterval(this.properties.getCardano().getKeepAliveInterval());
        storeProperties.setDefaultGenesisHash(this.properties.getCardano().getDefaultGenesisHash());
        storeProperties.setEnableParallelProcessing(this.properties.getExecutor().isEnableParallelProcessing());
        storeProperties.setBlockProcessingThreads(this.properties.getExecutor().getBlockProcessingThreads());
        storeProperties.setEventProcessingThreads(this.properties.getExecutor().getEventProcessingThreads());
        storeProperties.setBlocksBatchSize(this.properties.getExecutor().getBlocksBatchSize());
        storeProperties.setBlocksPartitionSize(this.properties.getExecutor().getBlocksPartitionSize());
        storeProperties.setUseVirtualThreadForBatchProcessing(this.properties.getExecutor().isUseVirtualThreadForBatchProcessing());
        storeProperties.setUseVirtualThreadForEventProcessing(this.properties.getExecutor().isUseVirtualThreadForEventProcessing());
        storeProperties.setProcessingThreadsTimeout(this.properties.getExecutor().getProcessingThreadsTimeout());
        storeProperties.setDbBatchSize(this.properties.getDb().getBatchSize());
        storeProperties.setDbParallelInsert(this.properties.getDb().isParallelInsert());
        storeProperties.setParallelWrite(this.properties.getDb().isParallelWrite());
        storeProperties.setWriteThreadDefaultBatchSize(this.properties.getDb().getWriteThreadDefaultBatchSize());
        storeProperties.setJooqWriteBatchSize(this.properties.getDb().getJooqWriteBatchSize());
        storeProperties.setWriteThreadCount(this.properties.getDb().getWriteThreadCount());
        storeProperties.setMvstoreEnabled(this.properties.isMvstoreEnabled());
        storeProperties.setMvstorePath(this.properties.getMvstorePath());
        storeProperties.setN2cPoolEnabled(this.properties.getCardano().isN2cPoolEnabled());
        storeProperties.setN2cPoolMaxTotal(this.properties.getCardano().getN2cPoolMaxTotal());
        storeProperties.setN2cPoolMinIdle(this.properties.getCardano().getN2cPoolMinIdle());
        storeProperties.setN2cPoolMaxIdle(this.properties.getCardano().getN2cPoolMaxIdle());
        storeProperties.setN2cPoolMaxWaitInMillis(this.properties.getCardano().getN2cPoolMaxWaitInMillis());
        return storeProperties;
    }

    static {
        System.setProperty("org.jooq.no-logo", "true");
        System.setProperty("org.jooq.no-tips", "true");
    }
}

