/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.staking.controller;

import com.bloxbean.cardano.yaci.store.api.staking.service.PoolService;
import com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration;
import com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Pool Service")
@RequestMapping(value={"${apiPrefix}/pools"})
@ConditionalOnExpression(value="${store.staking.endpoints.pool.enabled:true}")
public class PoolController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PoolController.class);
    private final PoolService poolService;

    @GetMapping(value={"/registrations"})
    @Operation(description="Get pool registrations by page number and count")
    public List<PoolRegistration> getPoolRegistrations(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.poolService.getPoolRegistrations(p, count);
    }

    @GetMapping(value={"/retirements"})
    @Operation(description="Get pool retirements by page number and count")
    public List<PoolRetirement> getRetirements(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.poolService.getPoolRetirements(p, count);
    }

    @Generated
    public PoolController(PoolService poolService) {
        this.poolService = poolService;
    }
}

