/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.staking.controller;

import com.bloxbean.cardano.yaci.store.api.staking.service.StakeService;
import com.bloxbean.cardano.yaci.store.staking.domain.Delegation;
import com.bloxbean.cardano.yaci.store.staking.domain.StakeRegistrationDetail;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Account Service")
@RequestMapping(value={"${apiPrefix}/stake"})
@ConditionalOnExpression(value="${store.staking.endpoints.account.enabled:true}")
public class StakeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StakeController.class);
    private final StakeService stakeService;

    @GetMapping(value={"/registrations"})
    @Operation(description="Get stake address registrations by page number and count")
    public List<StakeRegistrationDetail> getStakeRegistrations(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.stakeService.getStakeRegistrations(p, count);
    }

    @GetMapping(value={"/deregistrations"})
    @Operation(description="Get stake de-registrations by page number and count")
    public List<StakeRegistrationDetail> getStakeDeRegistrations(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.stakeService.getStakeDeregistrations(p, count);
    }

    @GetMapping(value={"/delegations"})
    @Operation(description="Get stake delegations by page number and count")
    public List<Delegation> getStakeDelegations(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.stakeService.getStakeDelegations(p, count);
    }

    @Generated
    public StakeController(StakeService stakeService) {
        this.stakeService = stakeService;
    }
}

