/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.domain;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.core.model.Relay;
import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class PoolRegistration
extends BlockAwareDomain {
    private String txHash;
    private int certIndex;
    private String poolId;
    private String vrfKeyHash;
    private BigInteger pledge;
    private BigInteger cost;
    private double margin;
    private String rewardAccount;
    private Set<String> poolOwners;
    private List<Relay> relays;
    private String metadataUrl;
    private String metadataHash;
    private int epoch;
    private long slot;
    private String blockHash;

    public String getRewardAccountBech32() {
        if (this.rewardAccount == null) {
            return "";
        }
        Address address = new Address(HexUtil.decodeHexString((String)this.rewardAccount));
        return address.toBech32();
    }

    public String getPoolIdBech32() {
        if (this.poolId == null) {
            return "";
        }
        return Bech32.encode((byte[])HexUtil.decodeHexString((String)this.poolId), (String)"pool");
    }

    @Generated
    protected PoolRegistration(PoolRegistrationBuilder<?, ?> b) {
        super(b);
        this.txHash = b.txHash;
        this.certIndex = b.certIndex;
        this.poolId = b.poolId;
        this.vrfKeyHash = b.vrfKeyHash;
        this.pledge = b.pledge;
        this.cost = b.cost;
        this.margin = b.margin;
        this.rewardAccount = b.rewardAccount;
        this.poolOwners = b.poolOwners;
        this.relays = b.relays;
        this.metadataUrl = b.metadataUrl;
        this.metadataHash = b.metadataHash;
        this.epoch = b.epoch;
        this.slot = b.slot;
        this.blockHash = b.blockHash;
    }

    @Generated
    public static PoolRegistrationBuilder<?, ?> builder() {
        return new PoolRegistrationBuilderImpl();
    }

    @Generated
    public PoolRegistrationBuilder<?, ?> toBuilder() {
        return new PoolRegistrationBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getTxHash() {
        return this.txHash;
    }

    @Generated
    public int getCertIndex() {
        return this.certIndex;
    }

    @Generated
    public String getPoolId() {
        return this.poolId;
    }

    @Generated
    public String getVrfKeyHash() {
        return this.vrfKeyHash;
    }

    @Generated
    public BigInteger getPledge() {
        return this.pledge;
    }

    @Generated
    public BigInteger getCost() {
        return this.cost;
    }

    @Generated
    public double getMargin() {
        return this.margin;
    }

    @Generated
    public String getRewardAccount() {
        return this.rewardAccount;
    }

    @Generated
    public Set<String> getPoolOwners() {
        return this.poolOwners;
    }

    @Generated
    public List<Relay> getRelays() {
        return this.relays;
    }

    @Generated
    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    @Generated
    public String getMetadataHash() {
        return this.metadataHash;
    }

    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @Generated
    public long getSlot() {
        return this.slot;
    }

    @Generated
    public String getBlockHash() {
        return this.blockHash;
    }

    @Generated
    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    @Generated
    public void setCertIndex(int certIndex) {
        this.certIndex = certIndex;
    }

    @Generated
    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    @Generated
    public void setVrfKeyHash(String vrfKeyHash) {
        this.vrfKeyHash = vrfKeyHash;
    }

    @Generated
    public void setPledge(BigInteger pledge) {
        this.pledge = pledge;
    }

    @Generated
    public void setCost(BigInteger cost) {
        this.cost = cost;
    }

    @Generated
    public void setMargin(double margin) {
        this.margin = margin;
    }

    @Generated
    public void setRewardAccount(String rewardAccount) {
        this.rewardAccount = rewardAccount;
    }

    @Generated
    public void setPoolOwners(Set<String> poolOwners) {
        this.poolOwners = poolOwners;
    }

    @Generated
    public void setRelays(List<Relay> relays) {
        this.relays = relays;
    }

    @Generated
    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    @Generated
    public void setMetadataHash(String metadataHash) {
        this.metadataHash = metadataHash;
    }

    @Generated
    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    @Generated
    public void setSlot(long slot) {
        this.slot = slot;
    }

    @Generated
    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolRegistration)) {
            return false;
        }
        PoolRegistration other = (PoolRegistration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCertIndex() != other.getCertIndex()) {
            return false;
        }
        if (Double.compare(this.getMargin(), other.getMargin()) != 0) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        String this$txHash = this.getTxHash();
        String other$txHash = other.getTxHash();
        if (this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash)) {
            return false;
        }
        String this$poolId = this.getPoolId();
        String other$poolId = other.getPoolId();
        if (this$poolId == null ? other$poolId != null : !this$poolId.equals(other$poolId)) {
            return false;
        }
        String this$vrfKeyHash = this.getVrfKeyHash();
        String other$vrfKeyHash = other.getVrfKeyHash();
        if (this$vrfKeyHash == null ? other$vrfKeyHash != null : !this$vrfKeyHash.equals(other$vrfKeyHash)) {
            return false;
        }
        BigInteger this$pledge = this.getPledge();
        BigInteger other$pledge = other.getPledge();
        if (this$pledge == null ? other$pledge != null : !((Object)this$pledge).equals(other$pledge)) {
            return false;
        }
        BigInteger this$cost = this.getCost();
        BigInteger other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        String this$rewardAccount = this.getRewardAccount();
        String other$rewardAccount = other.getRewardAccount();
        if (this$rewardAccount == null ? other$rewardAccount != null : !this$rewardAccount.equals(other$rewardAccount)) {
            return false;
        }
        Set<String> this$poolOwners = this.getPoolOwners();
        Set<String> other$poolOwners = other.getPoolOwners();
        if (this$poolOwners == null ? other$poolOwners != null : !((Object)this$poolOwners).equals(other$poolOwners)) {
            return false;
        }
        List<Relay> this$relays = this.getRelays();
        List<Relay> other$relays = other.getRelays();
        if (this$relays == null ? other$relays != null : !((Object)this$relays).equals(other$relays)) {
            return false;
        }
        String this$metadataUrl = this.getMetadataUrl();
        String other$metadataUrl = other.getMetadataUrl();
        if (this$metadataUrl == null ? other$metadataUrl != null : !this$metadataUrl.equals(other$metadataUrl)) {
            return false;
        }
        String this$metadataHash = this.getMetadataHash();
        String other$metadataHash = other.getMetadataHash();
        if (this$metadataHash == null ? other$metadataHash != null : !this$metadataHash.equals(other$metadataHash)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        return !(this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PoolRegistration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCertIndex();
        long $margin = Double.doubleToLongBits(this.getMargin());
        result = result * 59 + (int)($margin >>> 32 ^ $margin);
        result = result * 59 + this.getEpoch();
        long $slot = this.getSlot();
        result = result * 59 + (int)($slot >>> 32 ^ $slot);
        String $txHash = this.getTxHash();
        result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
        String $poolId = this.getPoolId();
        result = result * 59 + ($poolId == null ? 43 : $poolId.hashCode());
        String $vrfKeyHash = this.getVrfKeyHash();
        result = result * 59 + ($vrfKeyHash == null ? 43 : $vrfKeyHash.hashCode());
        BigInteger $pledge = this.getPledge();
        result = result * 59 + ($pledge == null ? 43 : ((Object)$pledge).hashCode());
        BigInteger $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        String $rewardAccount = this.getRewardAccount();
        result = result * 59 + ($rewardAccount == null ? 43 : $rewardAccount.hashCode());
        Set<String> $poolOwners = this.getPoolOwners();
        result = result * 59 + ($poolOwners == null ? 43 : ((Object)$poolOwners).hashCode());
        List<Relay> $relays = this.getRelays();
        result = result * 59 + ($relays == null ? 43 : ((Object)$relays).hashCode());
        String $metadataUrl = this.getMetadataUrl();
        result = result * 59 + ($metadataUrl == null ? 43 : $metadataUrl.hashCode());
        String $metadataHash = this.getMetadataHash();
        result = result * 59 + ($metadataHash == null ? 43 : $metadataHash.hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PoolRegistration(txHash=" + this.getTxHash() + ", certIndex=" + this.getCertIndex() + ", poolId=" + this.getPoolId() + ", vrfKeyHash=" + this.getVrfKeyHash() + ", pledge=" + String.valueOf(this.getPledge()) + ", cost=" + String.valueOf(this.getCost()) + ", margin=" + this.getMargin() + ", rewardAccount=" + this.getRewardAccount() + ", poolOwners=" + String.valueOf(this.getPoolOwners()) + ", relays=" + String.valueOf(this.getRelays()) + ", metadataUrl=" + this.getMetadataUrl() + ", metadataHash=" + this.getMetadataHash() + ", epoch=" + this.getEpoch() + ", slot=" + this.getSlot() + ", blockHash=" + this.getBlockHash() + ")";
    }

    @Generated
    public PoolRegistration() {
    }

    @Generated
    public PoolRegistration(String txHash, int certIndex, String poolId, String vrfKeyHash, BigInteger pledge, BigInteger cost, double margin, String rewardAccount, Set<String> poolOwners, List<Relay> relays, String metadataUrl, String metadataHash, int epoch, long slot, String blockHash) {
        this.txHash = txHash;
        this.certIndex = certIndex;
        this.poolId = poolId;
        this.vrfKeyHash = vrfKeyHash;
        this.pledge = pledge;
        this.cost = cost;
        this.margin = margin;
        this.rewardAccount = rewardAccount;
        this.poolOwners = poolOwners;
        this.relays = relays;
        this.metadataUrl = metadataUrl;
        this.metadataHash = metadataHash;
        this.epoch = epoch;
        this.slot = slot;
        this.blockHash = blockHash;
    }

    @Generated
    public static abstract class PoolRegistrationBuilder<C extends PoolRegistration, B extends PoolRegistrationBuilder<C, B>>
    extends BlockAwareDomain.BlockAwareDomainBuilder<C, B> {
        @Generated
        private String txHash;
        @Generated
        private int certIndex;
        @Generated
        private String poolId;
        @Generated
        private String vrfKeyHash;
        @Generated
        private BigInteger pledge;
        @Generated
        private BigInteger cost;
        @Generated
        private double margin;
        @Generated
        private String rewardAccount;
        @Generated
        private Set<String> poolOwners;
        @Generated
        private List<Relay> relays;
        @Generated
        private String metadataUrl;
        @Generated
        private String metadataHash;
        @Generated
        private int epoch;
        @Generated
        private long slot;
        @Generated
        private String blockHash;

        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PoolRegistrationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PoolRegistration instance, PoolRegistrationBuilder<?, ?> b) {
            b.txHash(instance.txHash);
            b.certIndex(instance.certIndex);
            b.poolId(instance.poolId);
            b.vrfKeyHash(instance.vrfKeyHash);
            b.pledge(instance.pledge);
            b.cost(instance.cost);
            b.margin(instance.margin);
            b.rewardAccount(instance.rewardAccount);
            b.poolOwners(instance.poolOwners);
            b.relays(instance.relays);
            b.metadataUrl(instance.metadataUrl);
            b.metadataHash(instance.metadataHash);
            b.epoch(instance.epoch);
            b.slot(instance.slot);
            b.blockHash(instance.blockHash);
        }

        @Generated
        public B txHash(String txHash) {
            this.txHash = txHash;
            return (B)this.self();
        }

        @Generated
        public B certIndex(int certIndex) {
            this.certIndex = certIndex;
            return (B)this.self();
        }

        @Generated
        public B poolId(String poolId) {
            this.poolId = poolId;
            return (B)this.self();
        }

        @Generated
        public B vrfKeyHash(String vrfKeyHash) {
            this.vrfKeyHash = vrfKeyHash;
            return (B)this.self();
        }

        @Generated
        public B pledge(BigInteger pledge) {
            this.pledge = pledge;
            return (B)this.self();
        }

        @Generated
        public B cost(BigInteger cost) {
            this.cost = cost;
            return (B)this.self();
        }

        @Generated
        public B margin(double margin) {
            this.margin = margin;
            return (B)this.self();
        }

        @Generated
        public B rewardAccount(String rewardAccount) {
            this.rewardAccount = rewardAccount;
            return (B)this.self();
        }

        @Generated
        public B poolOwners(Set<String> poolOwners) {
            this.poolOwners = poolOwners;
            return (B)this.self();
        }

        @Generated
        public B relays(List<Relay> relays) {
            this.relays = relays;
            return (B)this.self();
        }

        @Generated
        public B metadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
            return (B)this.self();
        }

        @Generated
        public B metadataHash(String metadataHash) {
            this.metadataHash = metadataHash;
            return (B)this.self();
        }

        @Generated
        public B epoch(int epoch) {
            this.epoch = epoch;
            return (B)this.self();
        }

        @Generated
        public B slot(long slot) {
            this.slot = slot;
            return (B)this.self();
        }

        @Generated
        public B blockHash(String blockHash) {
            this.blockHash = blockHash;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PoolRegistration.PoolRegistrationBuilder(super=" + super.toString() + ", txHash=" + this.txHash + ", certIndex=" + this.certIndex + ", poolId=" + this.poolId + ", vrfKeyHash=" + this.vrfKeyHash + ", pledge=" + String.valueOf(this.pledge) + ", cost=" + String.valueOf(this.cost) + ", margin=" + this.margin + ", rewardAccount=" + this.rewardAccount + ", poolOwners=" + String.valueOf(this.poolOwners) + ", relays=" + String.valueOf(this.relays) + ", metadataUrl=" + this.metadataUrl + ", metadataHash=" + this.metadataHash + ", epoch=" + this.epoch + ", slot=" + this.slot + ", blockHash=" + this.blockHash + ")";
        }
    }

    @Generated
    private static final class PoolRegistrationBuilderImpl
    extends PoolRegistrationBuilder<PoolRegistration, PoolRegistrationBuilderImpl> {
        @Generated
        private PoolRegistrationBuilderImpl() {
        }

        @Override
        @Generated
        protected PoolRegistrationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PoolRegistration build() {
            return new PoolRegistration(this);
        }
    }
}

