/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.processor;

import com.bloxbean.cardano.yaci.core.model.certs.Certificate;
import com.bloxbean.cardano.yaci.core.model.certs.CertificateType;
import com.bloxbean.cardano.yaci.core.model.certs.PoolRegistration;
import com.bloxbean.cardano.yaci.core.model.certs.PoolRetirement;
import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.bloxbean.cardano.yaci.store.events.CertificateEvent;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.events.domain.TxCertificates;
import com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration;
import com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement;
import com.bloxbean.cardano.yaci.store.staking.storage.PoolStorage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PoolRegistrationProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PoolRegistrationProcessor.class);
    private final PoolStorage poolStorage;

    @EventListener
    @Transactional
    public void processPoolRegistration(CertificateEvent certificateEvent) {
        EventMetadata eventMetadata = certificateEvent.getMetadata();
        for (TxCertificates txCertificates : certificateEvent.getTxCertificatesList()) {
            String txHash = txCertificates.getTxHash();
            List certificates = txCertificates.getCertificates();
            ArrayList<com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration> poolRegistrations = new ArrayList<com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration>();
            ArrayList<com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement> poolRetirements = new ArrayList<com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement>();
            int index = 0;
            for (Certificate certificate : certificates) {
                if (certificate.getType() == CertificateType.POOL_REGISTRATION) {
                    PoolRegistration poolRegistrationCert = (PoolRegistration)certificate;
                    BlockAwareDomain poolRegistration = ((PoolRegistration.PoolRegistrationBuilder)((PoolRegistration.PoolRegistrationBuilder)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)((PoolRegistration.PoolRegistrationBuilder)((Object)com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration.builder().txHash(txHash))).certIndex(index))).poolId(poolRegistrationCert.getPoolParams().getOperator()))).vrfKeyHash(poolRegistrationCert.getPoolParams().getVrfKeyHash()))).pledge(poolRegistrationCert.getPoolParams().getPledge()))).cost(poolRegistrationCert.getPoolParams().getCost()))).margin(this.poolMarginToDouble(poolRegistrationCert.getPoolParams().getMargin())))).rewardAccount(poolRegistrationCert.getPoolParams().getRewardAccount()))).poolOwners(poolRegistrationCert.getPoolParams().getPoolOwners()))).relays(poolRegistrationCert.getPoolParams().getRelays()))).metadataUrl(poolRegistrationCert.getPoolParams().getPoolMetadataUrl()))).metadataHash(poolRegistrationCert.getPoolParams().getPoolMetadataHash()))).epoch(eventMetadata.getEpochNumber()))).slot(eventMetadata.getSlot()).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).build();
                    poolRegistrations.add((com.bloxbean.cardano.yaci.store.staking.domain.PoolRegistration)poolRegistration);
                } else if (certificate.getType() == CertificateType.POOL_RETIREMENT) {
                    PoolRetirement poolRetirementCert = (PoolRetirement)certificate;
                    BlockAwareDomain poolRetirement = ((PoolRetirement.PoolRetirementBuilder)((PoolRetirement.PoolRetirementBuilder)((PoolRetirement.PoolRetirementBuilder)((Object)((PoolRetirement.PoolRetirementBuilder)((Object)((PoolRetirement.PoolRetirementBuilder)((Object)((PoolRetirement.PoolRetirementBuilder)((Object)((PoolRetirement.PoolRetirementBuilder)((Object)com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement.builder().txHash(txHash))).certIndex(index))).poolId(poolRetirementCert.getPoolKeyHash()))).retirementEpoch((int)poolRetirementCert.getEpoch()))).epoch(eventMetadata.getEpochNumber()))).slot(eventMetadata.getSlot()).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).build();
                    poolRetirements.add((com.bloxbean.cardano.yaci.store.staking.domain.PoolRetirement)poolRetirement);
                }
                ++index;
            }
            if (poolRegistrations.size() > 0) {
                this.poolStorage.savePoolRegistrations(poolRegistrations);
            }
            if (poolRetirements.size() <= 0) continue;
            this.poolStorage.savePoolRetirements(poolRetirements);
        }
    }

    private double poolMarginToDouble(String margin) {
        String[] tokens = margin.split("/");
        if (tokens.length == 2) {
            if (Double.parseDouble(tokens[1]) == 0.0) {
                log.error("Invalid margin value: " + margin);
                return 0.0;
            }
            return Double.parseDouble(tokens[0]) / Double.parseDouble(tokens[1]);
        }
        log.error("Invalid margin value: " + margin);
        return 0.0;
    }

    @EventListener
    @Transactional
    public void handleRollbackEvent(RollbackEvent rollbackEvent) {
        int count = this.poolStorage.deleteRegistrationsBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} pool_registration records", (Object)count);
        count = this.poolStorage.deleteRetirementsBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} pool_retirement records", (Object)count);
    }

    @Generated
    public PoolRegistrationProcessor(PoolStorage poolStorage) {
        this.poolStorage = poolStorage;
    }
}

