/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.processor;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.yaci.core.model.certs.Certificate;
import com.bloxbean.cardano.yaci.core.model.certs.CertificateType;
import com.bloxbean.cardano.yaci.core.model.certs.RegCert;
import com.bloxbean.cardano.yaci.core.model.certs.StakeDelegation;
import com.bloxbean.cardano.yaci.core.model.certs.StakeDeregistration;
import com.bloxbean.cardano.yaci.core.model.certs.StakePoolId;
import com.bloxbean.cardano.yaci.core.model.certs.StakeRegDelegCert;
import com.bloxbean.cardano.yaci.core.model.certs.StakeRegistration;
import com.bloxbean.cardano.yaci.core.model.certs.StakeVoteRegDelegCert;
import com.bloxbean.cardano.yaci.core.model.certs.UnregCert;
import com.bloxbean.cardano.yaci.core.model.certs.VoteRegDelegCert;
import com.bloxbean.cardano.yaci.store.events.CertificateEvent;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.events.domain.TxCertificates;
import com.bloxbean.cardano.yaci.store.staking.domain.Delegation;
import com.bloxbean.cardano.yaci.store.staking.domain.StakeRegistrationDetail;
import com.bloxbean.cardano.yaci.store.staking.storage.StakingStorage;
import com.bloxbean.cardano.yaci.store.staking.util.AddressUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StakeRegProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StakeRegProcessor.class);
    private final StakingStorage stakingStorage;

    @EventListener
    @Transactional
    public void processStakeRegistration(CertificateEvent certificateEvent) {
        EventMetadata eventMetadata = certificateEvent.getMetadata();
        ArrayList<StakeRegistrationDetail> stakeRegDeRegs = new ArrayList<StakeRegistrationDetail>();
        ArrayList<Delegation> delegations = new ArrayList<Delegation>();
        for (TxCertificates txCertificates : certificateEvent.getTxCertificatesList()) {
            String txHash = txCertificates.getTxHash();
            List certificates = txCertificates.getCertificates();
            int index = 0;
            for (Certificate certificate : certificates) {
                CertificateType certType = certificate.getType();
                switch (certType) {
                    case STAKE_REGISTRATION: 
                    case REG_CERT: 
                    case VOTE_REG_DELEG_CERT: {
                        StakeRegistration stakeRegistration = certType == CertificateType.STAKE_REGISTRATION ? (StakeRegistration)certificate : (certType == CertificateType.REG_CERT ? StakeRegistration.builder().stakeCredential(((RegCert)certificate).getStakeCredential()).build() : StakeRegistration.builder().stakeCredential(((VoteRegDelegCert)certificate).getStakeCredential()).build());
                        StakeRegistrationDetail stakeRegistrationDetail = this.buildStakeRegistrationDetail(stakeRegistration, txHash, index, eventMetadata);
                        stakeRegDeRegs.add(stakeRegistrationDetail);
                        break;
                    }
                    case STAKE_DEREGISTRATION: 
                    case UNREG_CERT: {
                        StakeDeregistration stakeDeregistration = certType == CertificateType.STAKE_DEREGISTRATION ? (StakeDeregistration)certificate : StakeDeregistration.builder().stakeCredential(((UnregCert)certificate).getStakeCredential()).build();
                        StakeRegistrationDetail stakeRegistrationDetail = this.buildStakeRegistrationDetail(stakeDeregistration, txHash, index, eventMetadata);
                        stakeRegDeRegs.add(stakeRegistrationDetail);
                        break;
                    }
                    case STAKE_DELEGATION: {
                        Delegation delegation = this.buildDelegation((StakeDelegation)certificate, txHash, index, eventMetadata);
                        delegations.add(delegation);
                        break;
                    }
                    case STAKE_REG_DELEG_CERT: 
                    case STAKE_VOTE_REG_DELEG_CERT: {
                        StakeDelegation stakeDelegation;
                        StakeRegistration stakeRegistration;
                        if (certType == CertificateType.STAKE_REG_DELEG_CERT) {
                            StakeRegDelegCert stakeRegDelegCert = (StakeRegDelegCert)certificate;
                            stakeDelegation = StakeDelegation.builder().stakeCredential(stakeRegDelegCert.getStakeCredential()).stakePoolId(StakePoolId.builder().poolKeyHash(stakeRegDelegCert.getPoolKeyHash()).build()).build();
                            stakeRegistration = StakeRegistration.builder().stakeCredential(stakeRegDelegCert.getStakeCredential()).build();
                        } else {
                            StakeVoteRegDelegCert stakeVoteRegDelegCert = (StakeVoteRegDelegCert)certificate;
                            stakeDelegation = StakeDelegation.builder().stakeCredential(stakeVoteRegDelegCert.getStakeCredential()).stakePoolId(StakePoolId.builder().poolKeyHash(stakeVoteRegDelegCert.getPoolKeyHash()).build()).build();
                            stakeRegistration = StakeRegistration.builder().stakeCredential(stakeVoteRegDelegCert.getStakeCredential()).build();
                        }
                        Delegation delegation = this.buildDelegation(stakeDelegation, txHash, index, eventMetadata);
                        StakeRegistrationDetail stakeRegistrationDetail = this.buildStakeRegistrationDetail(stakeRegistration, txHash, index, eventMetadata);
                        stakeRegDeRegs.add(stakeRegistrationDetail);
                        delegations.add(delegation);
                        break;
                    }
                }
                ++index;
            }
        }
        if (!stakeRegDeRegs.isEmpty()) {
            this.stakingStorage.saveRegistrations(stakeRegDeRegs);
        }
        if (!delegations.isEmpty()) {
            this.stakingStorage.saveDelegations(delegations);
        }
    }

    private StakeRegistrationDetail buildStakeRegistrationDetail(StakeRegistration stakeRegistration, String txHash, int certIndex, EventMetadata eventMetadata) {
        Address address = AddressUtil.getRewardAddress(stakeRegistration.getStakeCredential(), eventMetadata.isMainnet());
        return ((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)StakeRegistrationDetail.builder().credential(stakeRegistration.getStakeCredential().getHash()))).address(address.toBech32()))).slot(eventMetadata.getSlot()))).txHash(txHash))).certIndex(certIndex))).type(CertificateType.STAKE_REGISTRATION))).epoch(eventMetadata.getEpochNumber()))).slot(eventMetadata.getSlot()).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).build();
    }

    private StakeRegistrationDetail buildStakeRegistrationDetail(StakeDeregistration stakeDeregistration, String txHash, int certIndex, EventMetadata eventMetadata) {
        Address address = AddressUtil.getRewardAddress(stakeDeregistration.getStakeCredential(), eventMetadata.isMainnet());
        return ((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)((StakeRegistrationDetail.StakeRegistrationDetailBuilder)((Object)StakeRegistrationDetail.builder().credential(stakeDeregistration.getStakeCredential().getHash()))).address(address.toBech32()))).slot(eventMetadata.getSlot()))).txHash(txHash))).certIndex(certIndex))).type(CertificateType.STAKE_DEREGISTRATION))).epoch(eventMetadata.getEpochNumber()))).slot(eventMetadata.getSlot()).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).build();
    }

    private Delegation buildDelegation(StakeDelegation stakeDelegation, String txHash, int certIndex, EventMetadata eventMetadata) {
        Address address = AddressUtil.getRewardAddress(stakeDelegation.getStakeCredential(), eventMetadata.isMainnet());
        return ((Delegation.DelegationBuilder)((Delegation.DelegationBuilder)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)((Delegation.DelegationBuilder)((Object)Delegation.builder().credential(stakeDelegation.getStakeCredential().getHash()))).address(address.toBech32()))).slot(eventMetadata.getSlot()))).txHash(txHash))).certIndex(certIndex))).poolId(stakeDelegation.getStakePoolId().getPoolKeyHash()))).epoch(eventMetadata.getEpochNumber()))).slot(eventMetadata.getSlot()).blockNumber(Long.valueOf(eventMetadata.getBlock()))).blockHash(eventMetadata.getBlockHash()).blockTime(Long.valueOf(eventMetadata.getBlockTime()))).build();
    }

    @EventListener
    @Transactional
    public void handleRollbackEvent(RollbackEvent rollbackEvent) {
        int count = this.stakingStorage.deleteRegistrationsBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} staking_registrations records", (Object)count);
        count = this.stakingStorage.deleteDelegationsBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} staking_delegations records", (Object)count);
    }

    @Generated
    public StakeRegProcessor(StakingStorage stakingStorage) {
        this.stakingStorage = stakingStorage;
    }
}

