/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.storage.impl;

import com.bloxbean.cardano.yaci.store.staking.domain.Delegation;
import com.bloxbean.cardano.yaci.store.staking.domain.StakeRegistrationDetail;
import com.bloxbean.cardano.yaci.store.staking.storage.StakingStorage;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.mapper.StakingMapper;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.repository.DelegationRepository;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.repository.StakeRegistrationRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class StakeStorageImpl
implements StakingStorage {
    private final StakeRegistrationRepository registrationRepository;
    private final DelegationRepository delegationRepository;
    private final StakingMapper mapper;

    @Override
    public void saveRegistrations(List<StakeRegistrationDetail> stakeRegistration) {
        List stakeRegistrationEntities = stakeRegistration.stream().map(stakeRegistrationDetail -> this.mapper.toStakeResistrationEntity((StakeRegistrationDetail)((Object)stakeRegistrationDetail))).collect(Collectors.toList());
        this.registrationRepository.saveAll(stakeRegistrationEntities);
    }

    @Override
    public void saveDelegations(List<Delegation> delegations) {
        List delegationEntities = delegations.stream().map(delegation -> this.mapper.toDelegationEntity((Delegation)((Object)delegation))).collect(Collectors.toList());
        this.delegationRepository.saveAll(delegationEntities);
    }

    @Override
    public int deleteRegistrationsBySlotGreaterThan(Long slot) {
        return this.registrationRepository.deleteBySlotGreaterThan(slot);
    }

    @Override
    public int deleteDelegationsBySlotGreaterThan(Long slot) {
        return this.delegationRepository.deleteBySlotGreaterThan(slot);
    }

    @Generated
    public StakeStorageImpl(StakeRegistrationRepository registrationRepository, DelegationRepository delegationRepository, StakingMapper mapper) {
        this.registrationRepository = registrationRepository;
        this.delegationRepository = delegationRepository;
        this.mapper = mapper;
    }
}

