/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.storage.impl;

import com.bloxbean.cardano.yaci.store.staking.domain.Delegation;
import com.bloxbean.cardano.yaci.store.staking.domain.StakeRegistrationDetail;
import com.bloxbean.cardano.yaci.store.staking.storage.StakingStorageReader;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.mapper.StakingMapper;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.model.DelegationEntity;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.model.StakeRegistrationEntity;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.repository.DelegationRepository;
import com.bloxbean.cardano.yaci.store.staking.storage.impl.repository.StakeRegistrationRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class StakeStorageReaderImpl
implements StakingStorageReader {
    private final StakeRegistrationRepository registrationRepository;
    private final DelegationRepository delegationRepository;
    private final StakingMapper mapper;

    @Override
    public List<StakeRegistrationDetail> findRegistrations(int page, int count) {
        PageRequest sortedBySlot = PageRequest.of((int)page, (int)count, (Sort)Sort.by((String[])new String[]{"slot"}).descending());
        return this.registrationRepository.findRegistrations((Pageable)sortedBySlot).stream().map(stakeRegistrationEntity -> this.mapper.toStakeRegistrationDetail((StakeRegistrationEntity)((Object)stakeRegistrationEntity))).collect(Collectors.toList());
    }

    @Override
    public List<StakeRegistrationDetail> findDeregistrations(int page, int count) {
        PageRequest sortedBySlot = PageRequest.of((int)page, (int)count, (Sort)Sort.by((String[])new String[]{"slot"}).descending());
        return this.registrationRepository.findDeregestrations((Pageable)sortedBySlot).stream().map(stakeRegistrationEntity -> this.mapper.toStakeRegistrationDetail((StakeRegistrationEntity)((Object)stakeRegistrationEntity))).collect(Collectors.toList());
    }

    @Override
    public List<Delegation> findDelegations(int page, int count) {
        PageRequest sortedBySlot = PageRequest.of((int)page, (int)count, (Sort)Sort.by((String[])new String[]{"slot"}).descending());
        return this.delegationRepository.findDelegations((Pageable)sortedBySlot).stream().map(delegationEntity -> this.mapper.toDelegation((DelegationEntity)((Object)delegationEntity))).collect(Collectors.toList());
    }

    @Generated
    public StakeStorageReaderImpl(StakeRegistrationRepository registrationRepository, DelegationRepository delegationRepository, StakingMapper mapper) {
        this.registrationRepository = registrationRepository;
        this.delegationRepository = delegationRepository;
        this.mapper = mapper;
    }
}

