/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.staking.util;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.address.util.AddressEncoderDecoderUtil;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.spec.NetworkId;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.core.model.certs.StakeCredential;
import lombok.NonNull;

public class AddressUtil {
    private static final byte RWD_STAKE_KEY_HEADER_TYPE = -32;
    private static final byte RWD_STAKE_SCRIPT_HEADER_TYPE = -16;

    public static Address getRewardAddress(@NonNull StakeCredential stakeCredential, boolean isMainnet) {
        if (stakeCredential == null) {
            throw new NullPointerException("stakeCredential is marked non-null but is null");
        }
        Network network = isMainnet ? Networks.mainnet() : Networks.testnet();
        switch (stakeCredential.getType()) {
            case ADDR_KEYHASH: {
                return AddressUtil.getAddress(null, HexUtil.decodeHexString((String)stakeCredential.getHash()), (byte)-32, network, AddressType.Reward);
            }
            case SCRIPTHASH: {
                return AddressUtil.getAddress(null, HexUtil.decodeHexString((String)stakeCredential.getHash()), (byte)-16, network, AddressType.Reward);
            }
        }
        throw new AddressRuntimeException("Invalid credential type, should be either Key or Script. Stake Credential: " + String.valueOf(stakeCredential));
    }

    private static Address getAddress(byte[] paymentKeyHash, byte[] stakeKeyHash, byte headerKind, Network networkInfo, AddressType addressType) {
        NetworkId network = AddressEncoderDecoderUtil.getNetworkId((Network)networkInfo);
        String prefix = AddressEncoderDecoderUtil.getPrefixHeader((AddressType)addressType) + AddressEncoderDecoderUtil.getPrefixTail((NetworkId)network);
        byte header = AddressEncoderDecoderUtil.getAddressHeader((byte)headerKind, (Network)networkInfo, (AddressType)addressType);
        byte[] addressArray = AddressUtil.getAddressBytes(paymentKeyHash, stakeKeyHash, addressType, header);
        return new Address(prefix, addressArray);
    }

    private static byte[] getAddressBytes(byte[] paymentKeyHash, byte[] stakeKeyHash, AddressType addressType, byte header) {
        byte[] addressArray;
        switch (addressType) {
            case Base: {
                addressArray = new byte[1 + paymentKeyHash.length + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                System.arraycopy(stakeKeyHash, 0, addressArray, paymentKeyHash.length + 1, stakeKeyHash.length);
                break;
            }
            case Enterprise: {
                addressArray = new byte[1 + paymentKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                break;
            }
            case Reward: {
                addressArray = new byte[1 + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(stakeKeyHash, 0, addressArray, 1, stakeKeyHash.length);
                break;
            }
            case Ptr: {
                addressArray = new byte[1 + paymentKeyHash.length + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                System.arraycopy(stakeKeyHash, 0, addressArray, paymentKeyHash.length + 1, stakeKeyHash.length);
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown address type");
            }
        }
        return addressArray;
    }
}

