/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.transaction.controller;

import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.transaction.domain.Withdrawal;
import com.bloxbean.cardano.yaci.store.transaction.storage.WithdrawalStorageReader;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Account Service")
@RequestMapping(value={"${apiPrefix}/accounts"})
@ConditionalOnExpression(value="${store.transaction.endpoints.transaction.enabled:true}")
public class AccountWithdrawalController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccountWithdrawalController.class);
    private final WithdrawalStorageReader withdrawalStorageReader;

    @GetMapping(value={"{stakeAddress}/withdrawals"})
    @Operation(summary="Get withdrawals by stake address", description="Get withdrawals by stake address")
    public List<Withdrawal> getWithdrawalsByAccount(@PathVariable(name="stakeAddress") String stakeAddress, @RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.withdrawalStorageReader.getWithdrawalsByAddress(stakeAddress, p, count, Order.desc);
    }

    @Generated
    public AccountWithdrawalController(WithdrawalStorageReader withdrawalStorageReader) {
        this.withdrawalStorageReader = withdrawalStorageReader;
    }
}

