/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.transaction.controller;

import com.bloxbean.cardano.yaci.store.api.transaction.service.TransactionService;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionSummary;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Block Service")
@RequestMapping(value={"${apiPrefix}/blocks"})
@ConditionalOnExpression(value="${store.transaction.endpoints.block.enabled:true}")
public class BlockTransactionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BlockTransactionController.class);
    private final TransactionService transactionService;

    @GetMapping(value={"{block}/txs"})
    @Operation(summary="Block Transactions", description="Get a list of all transactions included in the provided block.")
    public List<TransactionSummary> getTransactions(@PathVariable String block) {
        if (block == null || block.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Block hash / Block number is required");
        }
        if (NumberUtils.isDigits((String)block)) {
            return this.transactionService.getTransactionsByBlockNumber(Long.parseLong(block));
        }
        return this.transactionService.getTransactionsByBlockHash(block);
    }

    @Generated
    public BlockTransactionController(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

