/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.transaction.controller;

import com.bloxbean.cardano.yaci.store.api.transaction.service.TransactionService;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionDetails;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionPage;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxInputsOutputs;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxnWitness;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Transaction Service")
@RequestMapping(value={"${apiPrefix}/txs"})
@ConditionalOnExpression(value="${store.transaction.endpoints.transaction.enabled:true}")
public class TransactionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionController.class);
    private final TransactionService transactionService;

    public TransactionController(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @GetMapping(value={"{txHash}"})
    @Operation(summary="Transaction Information", description="Get detailed information about a specific transaction.")
    public TransactionDetails getTransaction(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash) {
        return this.transactionService.getTransaction(txHash).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Transaction not found"));
    }

    @GetMapping(value={"{txHash}/utxos"})
    @Operation(summary="Transaction UTxOs", description="Return the UTxOs of a specific transaction.")
    public TxInputsOutputs getTransactionInputsOutputs(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash) {
        return this.transactionService.getTransaction(txHash).map(transactionDetails -> {
            TxInputsOutputs txInputsOutputs = new TxInputsOutputs();
            txInputsOutputs.setHash(txHash);
            txInputsOutputs.setInputs(transactionDetails.getInputs());
            txInputsOutputs.setOutputs(transactionDetails.getOutputs());
            return txInputsOutputs;
        }).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Transaction not found"));
    }

    @GetMapping
    @Operation(summary="Transactions List", description="Return list of transaction information by paging parameters.")
    public TransactionPage getTransactions(@RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.transactionService.getTransactions(p, count);
    }

    @GetMapping(value={"{txHash}/witnesses"})
    @Operation(summary="Transaction Witnesses", description="Return list of witnesses of a specific transaction.")
    public List<TxnWitness> getTransactionWitnesses(@PathVariable @Pattern(regexp="^[0-9a-fA-F]{64}$") @Pattern(regexp="^[0-9a-fA-F]{64}$") String txHash) {
        return this.transactionService.getTransactionWitnesses(txHash);
    }
}

