/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.transaction.service;

import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.serializers.PlutusDataJsonConverter;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionDetails;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionPage;
import com.bloxbean.cardano.yaci.store.transaction.domain.TransactionSummary;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxUtxo;
import com.bloxbean.cardano.yaci.store.transaction.domain.Txn;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxnWitness;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorageReader;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionWitnessStorageReader;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TransactionService {
    private final TransactionStorageReader transactionStorageReader;
    private final TransactionWitnessStorageReader transactionWitnessStorageReader;
    private final UtxoClient utxoClient;

    public Optional<TransactionDetails> getTransaction(String txHash) {
        Optional txnOptional = this.transactionStorageReader.getTransactionByTxHash(txHash);
        if (txnOptional.isPresent()) {
            return txnOptional.map(txn -> {
                List<TxUtxo> inputUtxos = this.resolveInputs(txn.getInputs());
                List<TxUtxo> outputUtxos = this.resolveInputs(txn.getOutputs());
                List<TxUtxo> collateralInputs = this.resolveInputs(txn.getCollateralInputs());
                List<TxUtxo> referenceInputs = this.resolveInputs(txn.getReferenceInputs());
                BigInteger totalOutput = outputUtxos.stream().filter(txUtxo -> txUtxo.getAmount() != null).flatMap(txUtxo -> txUtxo.getAmount().stream()).filter(amount -> "lovelace".equals(amount.getAssetName()) && !StringUtils.hasLength((String)amount.getPolicyId())).map(amount -> amount.getQuantity()).reduce(BigInteger.ZERO, BigInteger::add);
                return TransactionDetails.builder().hash(txn.getTxHash()).blockHeight(txn.getBlockNumber()).slot(txn.getSlot()).inputs(inputUtxos).outputs(outputUtxos).utxoCount(inputUtxos.size()).totalOutput(totalOutput).fees(txn.getFee()).ttl(txn.getTtl()).auxiliaryDataHash(txn.getAuxiliaryDataHash()).validityIntervalStart(txn.getValidityIntervalStart()).scriptDataHash(txn.getScriptDataHash()).collateralInputs(collateralInputs).requiredSigners(txn.getRequiredSigners()).netowrkId(txn.getNetowrkId()).collateralReturn(txn.getCollateralReturnJson()).totalCollateral(txn.getTotalCollateral()).referenceInputs(referenceInputs).build();
            });
        }
        return Optional.empty();
    }

    private TxUtxo resolveInput(UtxoKey utxoId) {
        return this.utxoClient.getUtxoById(utxoId).map(addressUtxo -> TxUtxo.builder().txHash(addressUtxo.getTxHash()).outputIndex(addressUtxo.getOutputIndex()).amount(addressUtxo.getAmounts()).dataHash(addressUtxo.getDataHash()).inlineDatum(addressUtxo.getInlineDatum()).scriptRef(addressUtxo.getScriptRef()).build()).orElse(TxUtxo.builder().txHash(utxoId.getTxHash()).outputIndex(utxoId.getOutputIndex()).build());
    }

    private List<TxUtxo> resolveInputs(List<UtxoKey> utxoIds) {
        if (utxoIds == null || utxoIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Map<UtxoKey, List<TxUtxo>> txUtxosMap = this.utxoClient.getUtxosByIds(utxoIds).stream().map(addressUtxo -> TxUtxo.builder().txHash(addressUtxo.getTxHash()).outputIndex(addressUtxo.getOutputIndex()).address(addressUtxo.getOwnerAddr()).stakeAddress(addressUtxo.getOwnerStakeAddr()).amount(addressUtxo.getAmounts()).dataHash(addressUtxo.getDataHash()).inlineDatum(addressUtxo.getInlineDatum()).scriptRef(addressUtxo.getScriptRef()).referenceScriptHash(addressUtxo.getReferenceScriptHash()).inlineDatumJson(this.inlineDatumToJson(addressUtxo.getInlineDatum())).build()).collect(Collectors.groupingBy(txUtxo -> new UtxoKey(txUtxo.getTxHash(), txUtxo.getOutputIndex())));
        return utxoIds.stream().map(utxoId -> txUtxosMap.containsKey(utxoId) ? (TxUtxo)((List)txUtxosMap.get(utxoId)).get(0) : TxUtxo.builder().txHash(utxoId.getTxHash()).outputIndex(utxoId.getOutputIndex()).build()).collect(Collectors.toList());
    }

    private JsonNode inlineDatumToJson(String inlineDatum) {
        try {
            PlutusData plutusData = PlutusData.deserialize((byte[])HexUtil.decodeHexString((String)inlineDatum));
            return JsonUtil.parseJson((String)PlutusDataJsonConverter.toJson((PlutusData)plutusData));
        }
        catch (Exception e) {
            return null;
        }
    }

    public TransactionPage getTransactions(int page, int count) {
        List txnPage = this.transactionStorageReader.getTransactions(page, count, Order.desc);
        List transactionSummaries = txnPage.stream().map(txn -> {
            List<TxUtxo> outputUtxos = this.resolveInputs(txn.getOutputs());
            List outputAddresses = outputUtxos.stream().filter(txUtxo -> txUtxo.getAddress() != null).map(txUtxo -> txUtxo.getAddress()).collect(Collectors.toList());
            BigInteger totalOutput = outputUtxos.stream().filter(txUtxo -> txUtxo.getAmount() != null).flatMap(txUtxo -> txUtxo.getAmount().stream()).filter(amt -> amt.getUnit().equals("lovelace")).map(amt -> amt.getQuantity()).reduce((qty1, qty2) -> qty1.add((BigInteger)qty2)).orElse(BigInteger.ZERO);
            TransactionSummary summary = TransactionSummary.builder().txHash(txn.getTxHash()).blockNumber(txn.getBlockNumber().longValue()).slot(txn.getSlot().longValue()).outputAddresses(outputAddresses).totalOutput(totalOutput).fee(txn.getFee()).build();
            return summary;
        }).collect(Collectors.toList());
        return TransactionPage.builder().transactionSummaries(transactionSummaries).build();
    }

    public List<TransactionSummary> getTransactionsByBlockNumber(long blockNumber) {
        List txns = this.transactionStorageReader.getTransactionsByBlockNumber(blockNumber);
        return this.getTransactionSummaries(txns);
    }

    public List<TransactionSummary> getTransactionsByBlockHash(String blockHash) {
        List txns = this.transactionStorageReader.getTransactionsByBlockHash(blockHash);
        return this.getTransactionSummaries(txns);
    }

    public List<TxnWitness> getTransactionWitnesses(String txHash) {
        return this.transactionWitnessStorageReader.getTransactionWitnesses(txHash);
    }

    private List<TransactionSummary> getTransactionSummaries(List<Txn> txns) {
        return txns.stream().map(txn -> {
            List<TxUtxo> outputUtxos = this.resolveInputs(txn.getOutputs());
            List outputAddresses = outputUtxos.stream().map(txUtxo -> txUtxo.getAddress()).collect(Collectors.toList());
            BigInteger totalOutput = outputUtxos.stream().flatMap(txUtxo -> txUtxo.getAmount().stream()).filter(amt -> amt.getUnit().equals("lovelace")).map(amt -> amt.getQuantity()).reduce((qty1, qty2) -> qty1.add((BigInteger)qty2)).orElse(BigInteger.ZERO);
            TransactionSummary summary = TransactionSummary.builder().txHash(txn.getTxHash()).blockNumber(txn.getBlockNumber().longValue()).slot(txn.getSlot().longValue()).outputAddresses(outputAddresses).totalOutput(totalOutput).fee(txn.getFee()).build();
            return summary;
        }).collect(Collectors.toList());
    }

    @Generated
    public TransactionService(TransactionStorageReader transactionStorageReader, TransactionWitnessStorageReader transactionWitnessStorageReader, UtxoClient utxoClient) {
        this.transactionStorageReader = transactionStorageReader;
        this.transactionWitnessStorageReader = transactionWitnessStorageReader;
        this.utxoClient = utxoClient;
    }
}

