/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.processor;

import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.yaci.core.model.BootstrapWitness;
import com.bloxbean.cardano.yaci.core.model.VkeyWitness;
import com.bloxbean.cardano.yaci.core.model.byron.ByronPkWitness;
import com.bloxbean.cardano.yaci.core.model.byron.ByronRedeemWitness;
import com.bloxbean.cardano.yaci.core.model.byron.ByronScriptWitness;
import com.bloxbean.cardano.yaci.core.model.byron.ByronTx;
import com.bloxbean.cardano.yaci.core.model.byron.ByronTxOut;
import com.bloxbean.cardano.yaci.core.model.byron.ByronTxWitnesses;
import com.bloxbean.cardano.yaci.core.model.byron.ByronUnknownWitness;
import com.bloxbean.cardano.yaci.core.model.byron.payload.ByronTxPayload;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.core.util.Tuple;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.util.StringUtil;
import com.bloxbean.cardano.yaci.store.events.ByronMainBlockEvent;
import com.bloxbean.cardano.yaci.store.events.internal.CommitEvent;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxWitnessType;
import com.bloxbean.cardano.yaci.store.transaction.domain.Txn;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxnWitness;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionWitnessStorage;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ByronTransactionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ByronTransactionProcessor.class);
    private final TransactionStorage transactionStorage;
    private final TransactionWitnessStorage transactionWitnessStorage;
    private final UtxoClient utxoClient;
    private List<Tuple<Txn, ByronTx>> unresolvedFeeTxns = Collections.synchronizedList(new ArrayList());

    @EventListener
    @Transactional
    public void handleByronTransactionEvent(ByronMainBlockEvent event) {
        List byronTxList = event.getByronMainBlock().getBody().getTxPayload().stream().map(byronTxPayload -> byronTxPayload.getTransaction()).collect(Collectors.toList());
        ArrayList<Txn> txList = new ArrayList<Txn>();
        for (ByronTx byronTx : byronTxList) {
            List<UtxoKey> inputs = byronTx.getInputs().stream().map(txIn -> new UtxoKey(txIn.getTxId(), Integer.valueOf(txIn.getIndex()))).collect(Collectors.toList());
            BigInteger fee = this.calculateFee(byronTx);
            AtomicInteger index = new AtomicInteger(0);
            List<UtxoKey> outputs = byronTx.getOutputs().stream().map(txOut -> new UtxoKey(byronTx.getTxHash(), Integer.valueOf(index.getAndIncrement()))).collect(Collectors.toList());
            index.set(0);
            BlockAwareDomain txn = ((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Txn.TxnBuilder)((Txn.TxnBuilder)((Object)Txn.builder().txHash(byronTx.getTxHash()))).blockHash(event.getMetadata().getBlockHash()).blockNumber(Long.valueOf(event.getMetadata().getBlock()))).blockTime(event.getMetadata().getBlockTime())).slot(event.getMetadata().getSlot()))).inputs(inputs))).outputs(outputs))).fee(fee))).build();
            if (fee == null) {
                this.unresolvedFeeTxns.add((Tuple<Txn, ByronTx>)new Tuple((Object)txn, (Object)byronTx));
                continue;
            }
            txList.add((Txn)txn);
        }
        if (txList.size() > 0) {
            this.transactionStorage.saveAll(txList);
        }
    }

    private BigInteger calculateFee(ByronTx byronTx) {
        BigInteger fee = null;
        List inputs = byronTx.getInputs().stream().map(txIn -> new UtxoKey(txIn.getTxId(), Integer.valueOf(txIn.getIndex()))).collect(Collectors.toList());
        List inputUtxos = this.utxoClient.getUtxosByIds(inputs);
        if (inputUtxos.size() != inputs.size()) {
            if (log.isDebugEnabled()) {
                log.debug("Input utxos not found for transaction : " + byronTx.getTxHash());
            }
        } else {
            BigInteger totalInputs = inputUtxos.stream().map(AddressUtxo::getLovelaceAmount).reduce(BigInteger::add).orElse(BigInteger.ZERO);
            BigInteger totalOutputs = byronTx.getOutputs().stream().map(ByronTxOut::getAmount).reduce(BigInteger::add).orElse(BigInteger.ZERO);
            fee = totalInputs.subtract(totalOutputs);
        }
        return fee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    @Transactional
    public void handleUnresolvedFee(CommitEvent preCommitEvent) {
        if (this.unresolvedFeeTxns.isEmpty()) {
            return;
        }
        ArrayList<Txn> txnList = new ArrayList<Txn>();
        try {
            for (Tuple<Txn, ByronTx> unresolvedTxs : this.unresolvedFeeTxns) {
                BigInteger fee = this.calculateFee((ByronTx)unresolvedTxs._2);
                if (fee != null) {
                    ((Txn)((Object)unresolvedTxs._1)).setFee(fee);
                } else {
                    ((Txn)((Object)unresolvedTxs._1)).setFee(BigInteger.ZERO);
                    log.warn("Fee not resolved for transaction : " + ((Txn)((Object)unresolvedTxs._1)).getTxHash());
                }
                txnList.add((Txn)((Object)unresolvedTxs._1));
            }
        }
        finally {
            this.unresolvedFeeTxns.clear();
        }
    }

    @EventListener
    @Transactional
    public void handleByronTransactionWitnesses(ByronMainBlockEvent event) {
        List byronTxPayloadsList = event.getByronMainBlock().getBody().getTxPayload().stream().toList();
        ArrayList<TxnWitness> txWitnesses = new ArrayList<TxnWitness>();
        for (ByronTxPayload byronTxPayload : byronTxPayloadsList) {
            List witnesses = byronTxPayload.getWitnesses();
            if (witnesses == null || witnesses.size() == 0) continue;
            int index = 0;
            for (ByronTxWitnesses witness : witnesses) {
                ByronTxWitnesses byronTxWitnesses;
                if (witness == null) continue;
                TxnWitness txnWitness = new TxnWitness();
                txnWitness.setTxHash(byronTxPayload.getTransaction().getTxHash());
                txnWitness.setIndex(index++);
                txnWitness.setSlot(event.getMetadata().getSlot());
                Objects.requireNonNull(witness);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VkeyWitness.class, BootstrapWitness.class, ByronPkWitness.class, ByronRedeemWitness.class, ByronScriptWitness.class, ByronUnknownWitness.class}, (Object)byronTxWitnesses, n)) {
                    case 0: {
                        VkeyWitness vkeyWitness = (VkeyWitness)byronTxWitnesses;
                        txnWitness.setPubKey(vkeyWitness.getKey());
                        txnWitness.setSignature(vkeyWitness.getSignature());
                        txnWitness.setType(TxWitnessType.VKEY_WITNESS);
                        break;
                    }
                    case 1: {
                        BootstrapWitness bootstrapWitness = (BootstrapWitness)byronTxWitnesses;
                        txnWitness.setPubKey(bootstrapWitness.getPublicKey());
                        txnWitness.setSignature(bootstrapWitness.getSignature());
                        txnWitness.setType(TxWitnessType.BOOTSTRAP_WITNESS);
                        break;
                    }
                    case 2: {
                        ByronPkWitness byronPkWitness = (ByronPkWitness)byronTxWitnesses;
                        txnWitness.setPubKey(byronPkWitness.getPublicKey());
                        txnWitness.setSignature(byronPkWitness.getSignature());
                        txnWitness.setType(TxWitnessType.BYRON_PK_WITNESS);
                        break;
                    }
                    case 3: {
                        ByronRedeemWitness byronRedeemWitness = (ByronRedeemWitness)byronTxWitnesses;
                        txnWitness.setPubKey(byronRedeemWitness.getRedeemPublicKey());
                        txnWitness.setSignature(byronRedeemWitness.getRedeemSignature());
                        txnWitness.setType(TxWitnessType.BYRON_REDEEM_WITNESS);
                        break;
                    }
                    case 4: {
                        ByronScriptWitness scriptWitness = (ByronScriptWitness)byronTxWitnesses;
                        log.warn("ByronScriptWitness found ----> Not sure how to handle this >>>>>>>>>>>>>>>");
                        txnWitness.setType(TxWitnessType.BYRON_SCRIPT_WITNESS);
                        break;
                    }
                    case 5: {
                        ByronUnknownWitness unknownWitness = (ByronUnknownWitness)byronTxWitnesses;
                        log.warn("ByronUnknownWitness found --> Not sure how to handle this >>>>>>>>>>>>>>>");
                        txnWitness.setType(TxWitnessType.BYRON_UNKNOWN_WITNESS);
                        break;
                    }
                    default: {
                        log.error("Invalid witness type : " + String.valueOf(witness));
                    }
                }
                try {
                    if (txnWitness.getPubKey() != null && !StringUtil.isEmpty((String)txnWitness.getPubKey())) {
                        txnWitness.setPubKeyhash(KeyGenUtil.getKeyHash((byte[])HexUtil.decodeHexString((String)txnWitness.getPubKey())));
                    }
                }
                catch (Exception e) {
                    log.error("Error generating keyhash for key : " + txnWitness.getPubKey(), (Throwable)e);
                }
                txWitnesses.add(txnWitness);
            }
        }
        if (txWitnesses.size() > 0) {
            this.transactionWitnessStorage.saveAll(txWitnesses);
        }
    }

    @Generated
    public ByronTransactionProcessor(TransactionStorage transactionStorage, TransactionWitnessStorage transactionWitnessStorage, UtxoClient utxoClient) {
        this.transactionStorage = transactionStorage;
        this.transactionWitnessStorage = transactionWitnessStorage;
        this.utxoClient = utxoClient;
    }
}

