/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.processor;

import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.events.GenesisBalance;
import com.bloxbean.cardano.yaci.store.events.GenesisBlockEvent;
import com.bloxbean.cardano.yaci.store.transaction.domain.Txn;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GenesisTransactionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenesisTransactionProcessor.class);
    private final TransactionStorage transactionStorage;

    @EventListener
    @Transactional
    public void processGenesisUtxos(GenesisBlockEvent genesisBlockEvent) {
        log.info("Processing genesis transactions ...");
        List genesisBalanceList = genesisBlockEvent.getGenesisBalances();
        if (genesisBalanceList == null || genesisBalanceList.size() == 0) {
            log.info("No genesis transaction found");
            return;
        }
        ArrayList<Txn> genesisTxns = new ArrayList<Txn>();
        for (GenesisBalance genesisBalance : genesisBalanceList) {
            UtxoKey output = new UtxoKey(genesisBalance.getTxnHash(), Integer.valueOf(0));
            BlockAwareDomain txn = ((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Object)((Txn.TxnBuilder)((Txn.TxnBuilder)((Txn.TxnBuilder)((Object)Txn.builder().txHash(genesisBalance.getTxnHash()))).blockHash(genesisBlockEvent.getBlockHash()).blockNumber(Long.valueOf(genesisBlockEvent.getBlock()))).blockTime(genesisBlockEvent.getBlockTime())).slot(genesisBlockEvent.getSlot()))).inputs(Collections.emptyList()))).outputs(List.of(output)))).fee(BigInteger.ZERO))).ttl(0L))).invalid(false))).build();
            genesisTxns.add((Txn)txn);
        }
        this.transactionStorage.saveAll(genesisTxns);
    }

    @Generated
    public GenesisTransactionProcessor(TransactionStorage transactionStorage) {
        this.transactionStorage = transactionStorage;
    }
}

