/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.processor;

import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.yaci.core.model.BootstrapWitness;
import com.bloxbean.cardano.yaci.core.model.TransactionOutput;
import com.bloxbean.cardano.yaci.core.model.VkeyWitness;
import com.bloxbean.cardano.yaci.core.model.Witnesses;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.helper.model.Transaction;
import com.bloxbean.cardano.yaci.store.common.domain.Amt;
import com.bloxbean.cardano.yaci.store.common.domain.BlockAwareDomain;
import com.bloxbean.cardano.yaci.store.common.domain.TxOuput;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.TransactionEvent;
import com.bloxbean.cardano.yaci.store.transaction.domain.InvalidTransaction;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxWitnessType;
import com.bloxbean.cardano.yaci.store.transaction.domain.Txn;
import com.bloxbean.cardano.yaci.store.transaction.domain.TxnWitness;
import com.bloxbean.cardano.yaci.store.transaction.storage.InvalidTransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionWitnessStorage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransactionProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionProcessor.class);
    public static final String CHAINCODE = "chaincode";
    public static final String ATTRIBUTES = "attributes";
    private final TransactionStorage transactionStorage;
    private final TransactionWitnessStorage transactionWitnessStorage;
    private final InvalidTransactionStorage invalidTransactionStorage;
    private final ObjectMapper objectMapper;

    @EventListener
    @Order(value=3)
    @Transactional
    public void handleTransactionEvent(TransactionEvent event) {
        List transactions = event.getTransactions();
        ArrayList<Txn> txList = new ArrayList<Txn>();
        transactions.forEach(transaction -> {
            List<UtxoKey> inputs = transaction.getBody().getInputs().stream().map(transactionInput -> new UtxoKey(transactionInput.getTransactionId(), Integer.valueOf(transactionInput.getIndex()))).collect(Collectors.toList());
            AtomicInteger index = new AtomicInteger(0);
            List<UtxoKey> outputs = transaction.getBody().getOutputs().stream().map(transactionOutput -> new UtxoKey(transaction.getTxHash(), Integer.valueOf(index.getAndIncrement()))).collect(Collectors.toList());
            index.set(0);
            List<UtxoKey> collateralInputs = null;
            if (transaction.getBody().getCollateralInputs() != null) {
                collateralInputs = transaction.getBody().getCollateralInputs().stream().map(transactionInput -> new UtxoKey(transactionInput.getTransactionId(), Integer.valueOf(transactionInput.getIndex()))).collect(Collectors.toList());
            }
            List<UtxoKey> referenceInputs = null;
            if (transaction.getBody().getReferenceInputs() != null) {
                referenceInputs = transaction.getBody().getReferenceInputs().stream().map(transactionInput -> new UtxoKey(transactionInput.getTransactionId(), Integer.valueOf(transactionInput.getIndex()))).collect(Collectors.toList());
            }
            BlockAwareDomain txn = ((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Object)((Object)((Txn.TxnBuilder)((Txn.TxnBuilder)((Txn.TxnBuilder)((Object)((Object)Txn.builder().txHash(transaction.getTxHash())))).blockHash(event.getMetadata().getBlockHash()).blockNumber(Long.valueOf(transaction.getBlockNumber()))).blockTime(event.getMetadata().getBlockTime())).slot(transaction.getSlot())))).inputs(inputs)))).outputs(outputs)))).fee(transaction.getBody().getFee())))).ttl(transaction.getBody().getTtl())))).auxiliaryDataHash(transaction.getBody().getAuxiliaryDataHash())))).validityIntervalStart(transaction.getBody().getValidityIntervalStart())))).scriptDataHash(transaction.getBody().getScriptDataHash())))).collateralInputs(collateralInputs)))).collateralReturnJson(this.convertOutput(transaction.getBody().getCollateralReturn()))))).netowrkId(transaction.getBody().getNetowrkId())))).totalCollateral(transaction.getBody().getTotalCollateral())))).collateralReturn(new UtxoKey(transaction.getTxHash(), Integer.valueOf(outputs.size())))))).referenceInputs(referenceInputs)))).invalid(transaction.isInvalid())))).build();
            txList.add((Txn)txn);
            if (transaction.isInvalid()) {
                this.saveInvalidTransaction(event.getMetadata(), (Transaction)transaction);
            }
        });
        if (txList.size() > 0) {
            this.transactionStorage.saveAll(txList);
        }
    }

    private void saveInvalidTransaction(EventMetadata metadata, Transaction transaction) {
        InvalidTransaction invalidTransaction = InvalidTransaction.builder().txHash(transaction.getTxHash()).slot(metadata.getSlot()).blockHash(metadata.getBlockHash()).transaction(transaction).build();
        this.invalidTransactionStorage.save(invalidTransaction);
    }

    @EventListener
    @Transactional
    public void handleTransactionWitnesses(TransactionEvent event) {
        List transactions = event.getTransactions();
        ArrayList<TxnWitness> txnWitnesses = new ArrayList<TxnWitness>();
        int index = 0;
        for (Transaction transaction : transactions) {
            Object txnWitness;
            Witnesses witnesses = transaction.getWitnesses();
            if (witnesses == null) {
                return;
            }
            List vkeyWitnessList = witnesses.getVkeyWitnesses();
            List bootstrapWitnessList = witnesses.getBootstrapWitnesses();
            if (vkeyWitnessList != null && vkeyWitnessList.size() > 0) {
                for (VkeyWitness vkeyWitness : vkeyWitnessList) {
                    txnWitness = ((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)TxnWitness.builder().txHash(transaction.getTxHash())).index(index++)).pubKey(vkeyWitness.getKey())).signature(vkeyWitness.getSignature())).type(TxWitnessType.VKEY_WITNESS)).slot(event.getMetadata().getSlot())).build();
                    ((TxnWitness)txnWitness).setPubKeyhash(this.getKeyHash(((TxnWitness)txnWitness).getPubKey()));
                    txnWitnesses.add((TxnWitness)txnWitness);
                }
            }
            if (bootstrapWitnessList != null && bootstrapWitnessList.size() > 0) {
                for (BootstrapWitness bootstrapWitness : bootstrapWitnessList) {
                    txnWitness = ((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)((TxnWitness.TxnWitnessBuilder)TxnWitness.builder().txHash(transaction.getTxHash())).index(index++)).pubKey(bootstrapWitness.getPublicKey())).signature(bootstrapWitness.getSignature())).type(TxWitnessType.BOOTSTRAP_WITNESS)).slot(event.getMetadata().getSlot())).build();
                    ((TxnWitness)txnWitness).setPubKeyhash(this.getKeyHash(((TxnWitness)txnWitness).getPubKey()));
                    ObjectNode objectNode = this.objectMapper.createObjectNode();
                    objectNode.put(CHAINCODE, bootstrapWitness.getChainCode());
                    objectNode.put(ATTRIBUTES, bootstrapWitness.getAttributes());
                    ((TxnWitness)txnWitness).setAdditionalData((JsonNode)objectNode);
                    txnWitnesses.add((TxnWitness)txnWitness);
                }
            }
            if (txnWitnesses.size() <= 0) continue;
            this.transactionWitnessStorage.saveAll(txnWitnesses);
        }
    }

    private String getKeyHash(String pubKey) {
        try {
            return KeyGenUtil.getKeyHash((byte[])HexUtil.decodeHexString((String)pubKey));
        }
        catch (Exception e) {
            log.error("Error generating keyhash for key : " + pubKey, (Throwable)e);
            return null;
        }
    }

    private TxOuput convertOutput(TransactionOutput output) {
        if (output == null) {
            return null;
        }
        List amounts = output.getAmounts().stream().map(amount -> Amt.builder().unit(amount.getUnit()).policyId(amount.getPolicyId()).assetName(amount.getAssetName().replace('\u0000', ' ')).quantity(amount.getQuantity()).build()).collect(Collectors.toList());
        TxOuput txOuput = TxOuput.builder().address(output.getAddress()).dataHash(output.getDatumHash()).inlineDatum(output.getInlineDatum()).referenceScriptHash(output.getScriptRef()).amounts(amounts).build();
        return txOuput;
    }

    @Generated
    public TransactionProcessor(TransactionStorage transactionStorage, TransactionWitnessStorage transactionWitnessStorage, InvalidTransactionStorage invalidTransactionStorage, ObjectMapper objectMapper) {
        this.transactionStorage = transactionStorage;
        this.transactionWitnessStorage = transactionWitnessStorage;
        this.invalidTransactionStorage = invalidTransactionStorage;
        this.objectMapper = objectMapper;
    }
}

