/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.processor;

import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.transaction.storage.InvalidTransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionWitnessStorage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class TransactionRollbackProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionRollbackProcessor.class);
    private final TransactionStorage transactionStorage;
    private final TransactionWitnessStorage transactionWitnessStorage;
    private final InvalidTransactionStorage invalidTransactionStorage;

    @EventListener
    @Transactional
    public void handleRollbackEvent(RollbackEvent rollbackEvent) {
        int count = this.transactionStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} transactions records", (Object)count);
        count = this.transactionWitnessStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} transaction_witness records", (Object)count);
        count = this.invalidTransactionStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} invalid_transaction records", (Object)count);
    }

    @Generated
    public TransactionRollbackProcessor(TransactionStorage transactionStorage, TransactionWitnessStorage transactionWitnessStorage, InvalidTransactionStorage invalidTransactionStorage) {
        this.transactionStorage = transactionStorage;
        this.transactionWitnessStorage = transactionWitnessStorage;
        this.invalidTransactionStorage = invalidTransactionStorage;
    }
}

