/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.processor;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.yaci.core.util.HexUtil;
import com.bloxbean.cardano.yaci.helper.model.Transaction;
import com.bloxbean.cardano.yaci.store.events.EventMetadata;
import com.bloxbean.cardano.yaci.store.events.RollbackEvent;
import com.bloxbean.cardano.yaci.store.events.TransactionEvent;
import com.bloxbean.cardano.yaci.store.transaction.domain.Withdrawal;
import com.bloxbean.cardano.yaci.store.transaction.domain.WithdrawalEvent;
import com.bloxbean.cardano.yaci.store.transaction.storage.WithdrawalStorage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WithdrawalProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WithdrawalProcessor.class);
    private final WithdrawalStorage withdrawalStorage;
    private final ApplicationEventPublisher publisher;

    @EventListener
    @Transactional
    public void processWithdrawal(TransactionEvent transactionEvent) {
        EventMetadata metadata = transactionEvent.getMetadata();
        List transactions = transactionEvent.getTransactions();
        ArrayList<Withdrawal> withdrawals = null;
        for (Transaction transaction : transactions) {
            List<Withdrawal> withdrawalsToSave;
            Map txWithdrawals = transaction.getBody().getWithdrawals();
            if (txWithdrawals == null || txWithdrawals.isEmpty()) continue;
            if (withdrawals == null) {
                withdrawals = new ArrayList<Withdrawal>();
            }
            if ((withdrawalsToSave = txWithdrawals.entrySet().stream().map(entry -> {
                String addressHex = (String)entry.getKey();
                BigInteger amount = (BigInteger)entry.getValue();
                Address address = new Address(HexUtil.decodeHexString((String)addressHex));
                String stakeAddress = address.toBech32();
                Withdrawal withdrawal = new Withdrawal();
                withdrawal.setAddress(stakeAddress);
                withdrawal.setAmount(amount);
                withdrawal.setTxHash(transaction.getTxHash());
                withdrawal.setSlot(metadata.getSlot());
                withdrawal.setEpoch(metadata.getEpochNumber());
                withdrawal.setBlockNumber(metadata.getBlock());
                withdrawal.setBlockTime(metadata.getBlockTime());
                return withdrawal;
            }).toList()).size() <= 0) continue;
            withdrawals.addAll(withdrawalsToSave);
        }
        if (withdrawals != null && withdrawals.size() > 0) {
            this.withdrawalStorage.save((List<Withdrawal>)withdrawals);
            this.publisher.publishEvent((Object)new WithdrawalEvent(metadata, (List<Withdrawal>)withdrawals));
        }
    }

    @EventListener
    @Transactional
    public void handleRollbackEvent(RollbackEvent rollbackEvent) {
        int count = this.withdrawalStorage.deleteBySlotGreaterThan(rollbackEvent.getRollbackTo().getSlot());
        log.info("Rollback -- {} withdrawal records", (Object)count);
    }

    @Generated
    public WithdrawalProcessor(WithdrawalStorage withdrawalStorage, ApplicationEventPublisher publisher) {
        this.withdrawalStorage = withdrawalStorage;
        this.publisher = publisher;
    }
}

