/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.scheduler;

import com.bloxbean.cardano.yaci.store.common.service.CursorService;
import com.bloxbean.cardano.yaci.store.events.EpochChangeEvent;
import com.bloxbean.cardano.yaci.store.transaction.TransactionStoreProperties;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorage;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionWitnessStorage;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@ConditionalOnProperty(value={"store.transaction.pruning-enabled"}, havingValue="true")
public class TransactionPruningService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionPruningService.class);
    private final TransactionStorage transactionStorage;
    private final TransactionWitnessStorage transactionWitnessStorage;
    private final CursorService cursorService;
    private final TransactionStoreProperties transactionStoreProperties;
    private final AtomicBoolean isPruning = new AtomicBoolean(false);

    @PostConstruct
    public void init() {
        log.info("<< Transaction Pruning Service Enabled >>");
    }

    @Scheduled(fixedRateString="${store.transaction.pruning-interval:86400}", timeUnit=TimeUnit.SECONDS)
    public void handleTransactionPruning() {
        if (this.isPruning.get()) {
            log.info("Transaction pruning is already in progress. Skipping this run !!!");
            return;
        }
        Thread.startVirtualThread(this::deleteOldTransactions);
    }

    @EventListener
    @Transactional
    public void handleEpochChangeEvent(EpochChangeEvent epochChangeEvent) {
        if (this.isPruning.get()) {
            log.info("Transaction pruning is already in progress. Skipping this run !!!");
            return;
        }
        Thread.startVirtualThread(this::deleteOldTransactions);
    }

    private void deleteOldTransactions() {
        this.isPruning.set(true);
        try {
            this.cursorService.getCursor().ifPresent(cursor -> {
                log.info("Current cursor: {}", (Object)cursor.getBlock());
                long slot = cursor.getSlot() - (long)this.transactionStoreProperties.getPruningSafeSlot();
                if (slot > 0L) {
                    long t1 = System.currentTimeMillis();
                    int deleteTxCount = this.transactionStorage.deleteBySlotLessThan(slot);
                    int deleteTxWitnessCount = this.transactionWitnessStorage.deleteBySlotLessThan(slot);
                    long t2 = System.currentTimeMillis();
                    log.info("Deleted {} transactions and {} transaction witnesses before slot {}, Time taken: {} ms", new Object[]{deleteTxCount, deleteTxWitnessCount, slot, t2 - t1});
                }
            });
        }
        finally {
            this.isPruning.set(false);
        }
    }

    @Generated
    public TransactionPruningService(TransactionStorage transactionStorage, TransactionWitnessStorage transactionWitnessStorage, CursorService cursorService, TransactionStoreProperties transactionStoreProperties) {
        this.transactionStorage = transactionStorage;
        this.transactionWitnessStorage = transactionWitnessStorage;
        this.cursorService = cursorService;
        this.transactionStoreProperties = transactionStoreProperties;
    }
}

