/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.storage.impl;

import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.transaction.domain.Txn;
import com.bloxbean.cardano.yaci.store.transaction.jooq.tables.Transaction;
import com.bloxbean.cardano.yaci.store.transaction.storage.TransactionStorageReader;
import com.bloxbean.cardano.yaci.store.transaction.storage.impl.mapper.TxnMapper;
import com.bloxbean.cardano.yaci.store.transaction.storage.impl.model.TxnEntity;
import com.bloxbean.cardano.yaci.store.transaction.storage.impl.repository.TxnEntityRepository;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jooq.DSLContext;
import org.jooq.OrderField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectLimitPercentAfterOffsetStep;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class TransactionStorageReaderImpl
implements TransactionStorageReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionStorageReaderImpl.class);
    private final TxnEntityRepository txnEntityRepository;
    private final TxnMapper mapper;
    private final DSLContext dsl;

    @Override
    public Optional<Txn> getTransactionByTxHash(String txHash) {
        return this.txnEntityRepository.findByTxHash(txHash).map(this.mapper::toTxn);
    }

    @Override
    public List<Txn> getTransactions(int page, int count, Order order) {
        PageRequest pageable = PageRequest.of((int)page, (int)count).withSort(order.equals((Object)Order.desc) ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"slot"});
        SelectLimitPercentAfterOffsetStep query = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)Transaction.TRANSACTION).orderBy((OrderField)(order.equals((Object)Order.desc) ? Transaction.TRANSACTION.SLOT.desc() : Transaction.TRANSACTION.SLOT.asc())).offset((Number)pageable.getOffset()).limit((Number)pageable.getPageSize());
        List<Txn> transactions = query.fetch().into(TxnEntity.class).stream().map(this.mapper::toTxn).collect(Collectors.toList());
        return transactions;
    }

    @Override
    public List<Txn> getTransactionsByBlockHash(String blockHash) {
        return this.txnEntityRepository.findAllByBlockHash(blockHash).stream().map(this.mapper::toTxn).collect(Collectors.toList());
    }

    @Override
    public List<Txn> getTransactionsByBlockNumber(long blockNumber) {
        return this.txnEntityRepository.findAllByBlockNumber(blockNumber).stream().map(this.mapper::toTxn).collect(Collectors.toList());
    }

    @Generated
    public TransactionStorageReaderImpl(TxnEntityRepository txnEntityRepository, TxnMapper mapper, DSLContext dsl) {
        this.txnEntityRepository = txnEntityRepository;
        this.mapper = mapper;
        this.dsl = dsl;
    }
}

