/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.transaction.storage.impl.model;

import com.bloxbean.cardano.yaci.helper.model.Transaction;
import com.bloxbean.cardano.yaci.store.common.model.BaseEntity;
import com.bloxbean.cardano.yaci.store.common.util.JsonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Type;

@Entity
@Table(name="invalid_transaction")
public class InvalidTransactionEntity
extends BaseEntity {
    @Id
    @Column(name="tx_hash")
    private String txHash;
    @Column(name="slot")
    private Long slot;
    @Column(name="block_hash")
    private String blockHash;
    @Type(value=JsonType.class)
    @Column(columnDefinition="json")
    private Transaction transaction;

    @PrePersist
    public void prePersist() {
        if (this.transaction == null) {
            return;
        }
        String json = JsonUtil.getJson((Object)this.transaction);
        if (json.contains("\\u0000")) {
            json = json.replace("\\u0000", "");
            try {
                Transaction updatedTransaction = (Transaction)JsonUtil.getMapper().readValue(json, Transaction.class);
                this.setTransaction(updatedTransaction);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error deserializing transaction json", e);
            }
        }
    }

    @Generated
    public static InvalidTransactionEntityBuilder builder() {
        return new InvalidTransactionEntityBuilder();
    }

    @Generated
    public String getTxHash() {
        return this.txHash;
    }

    @Generated
    public Long getSlot() {
        return this.slot;
    }

    @Generated
    public String getBlockHash() {
        return this.blockHash;
    }

    @Generated
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Generated
    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    @Generated
    public void setSlot(Long slot) {
        this.slot = slot;
    }

    @Generated
    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    @Generated
    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvalidTransactionEntity)) {
            return false;
        }
        InvalidTransactionEntity other = (InvalidTransactionEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$slot = this.getSlot();
        Long other$slot = other.getSlot();
        if (this$slot == null ? other$slot != null : !((Object)this$slot).equals(other$slot)) {
            return false;
        }
        String this$txHash = this.getTxHash();
        String other$txHash = other.getTxHash();
        if (this$txHash == null ? other$txHash != null : !this$txHash.equals(other$txHash)) {
            return false;
        }
        String this$blockHash = this.getBlockHash();
        String other$blockHash = other.getBlockHash();
        if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
            return false;
        }
        Transaction this$transaction = this.getTransaction();
        Transaction other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvalidTransactionEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : ((Object)$slot).hashCode());
        String $txHash = this.getTxHash();
        result = result * 59 + ($txHash == null ? 43 : $txHash.hashCode());
        String $blockHash = this.getBlockHash();
        result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
        Transaction $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InvalidTransactionEntity(txHash=" + this.getTxHash() + ", slot=" + this.getSlot() + ", blockHash=" + this.getBlockHash() + ", transaction=" + String.valueOf(this.getTransaction()) + ")";
    }

    @Generated
    public InvalidTransactionEntity() {
    }

    @Generated
    public InvalidTransactionEntity(String txHash, Long slot, String blockHash, Transaction transaction) {
        this.txHash = txHash;
        this.slot = slot;
        this.blockHash = blockHash;
        this.transaction = transaction;
    }

    @Generated
    public static class InvalidTransactionEntityBuilder {
        @Generated
        private String txHash;
        @Generated
        private Long slot;
        @Generated
        private String blockHash;
        @Generated
        private Transaction transaction;

        @Generated
        InvalidTransactionEntityBuilder() {
        }

        @Generated
        public InvalidTransactionEntityBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        @Generated
        public InvalidTransactionEntityBuilder slot(Long slot) {
            this.slot = slot;
            return this;
        }

        @Generated
        public InvalidTransactionEntityBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        @Generated
        public InvalidTransactionEntityBuilder transaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        @Generated
        public InvalidTransactionEntity build() {
            return new InvalidTransactionEntity(this.txHash, this.slot, this.blockHash, this.transaction);
        }

        @Generated
        public String toString() {
            return "InvalidTransactionEntity.InvalidTransactionEntityBuilder(txHash=" + this.txHash + ", slot=" + this.slot + ", blockHash=" + this.blockHash + ", transaction=" + String.valueOf(this.transaction) + ")";
        }
    }
}

