/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.controller;

import com.bloxbean.cardano.yaci.store.api.utxo.service.AddressService;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Address Service")
@RequestMapping(value={"${apiPrefix}/addresses"})
@ConditionalOnExpression(value="${store.utxo.endpoints.address.enabled:true}")
public class AddressController {
    private final AddressService addressService;

    public AddressController(AddressService addressService) {
        this.addressService = addressService;
    }

    @GetMapping(value={"{address}/utxos"})
    @Operation(summary="Get UTxOs for an address or address verification key hash (addr_vkh). If the address is a stake address, it will return UTXOs for all base addresses associated with the stake address")
    public List<Utxo> getUtxos(@PathVariable String address, @RequestParam(required=false, defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count, @RequestParam(required=false, defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(required=false, defaultValue="asc") Order order) {
        int p = page;
        if (p > 0) {
            --p;
        }
        if (address.startsWith("addr_vkh")) {
            return this.addressService.getUtxoByPaymentCredential(address, p, count, order);
        }
        if (address.startsWith("stake")) {
            return this.addressService.getUtxoByStakeAddress(address, p, count, order);
        }
        return this.addressService.getUtxoByAddress(address, p, count, order);
    }

    @GetMapping(value={"{address}/utxos/{asset}"})
    @Operation(summary="Get UTxOs for an address or address verification key hash (addr_vkh) for a specific asset. If the address is a stake address, it will return UTXOs for all base addresses associated with the stake address")
    public List<Utxo> getUtxosForAsset(@PathVariable String address, @PathVariable String asset, @RequestParam(required=false, defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count, @RequestParam(required=false, defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(required=false, defaultValue="asc") Order order) {
        int p = page;
        if (p > 0) {
            --p;
        }
        if (address.startsWith("addr_vkh")) {
            return this.addressService.getUtxoByPaymentCredentialAndAsset(address, asset, p, count, order);
        }
        if (address.startsWith("stake")) {
            return this.addressService.getUtxoByStakeAddressAndAsset(address, asset, p, count, order);
        }
        return this.addressService.getUtxoByAddressAndAsset(address, asset, p, count, order);
    }
}

