/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.service;

import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.util.StringUtil;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UtxoUtil {
    private static final Logger log = LoggerFactory.getLogger(UtxoUtil.class);

    UtxoUtil() {
    }

    public static Utxo addressUtxoToUtxo(AddressUtxo addressUtxo) {
        String dataHash = addressUtxo.getDataHash();
        try {
            if (StringUtil.isEmpty((String)dataHash) && !StringUtil.isEmpty((String)addressUtxo.getInlineDatum())) {
                byte[] inlineDatumBytes = HexUtil.decodeHexString((String)addressUtxo.getInlineDatum());
                dataHash = PlutusData.deserialize((byte[])inlineDatumBytes).getDatumHash();
            }
        }
        catch (Exception e) {
            log.error("Invalid inline datum found in utxo tx : {}, index: {}, inline_datum: {}", new Object[]{addressUtxo.getTxHash(), addressUtxo.getOutputIndex(), addressUtxo.getInlineDatum()});
        }
        return Utxo.builder().txHash(addressUtxo.getTxHash()).outputIndex(addressUtxo.getOutputIndex().intValue()).address(addressUtxo.getOwnerAddr()).amount(addressUtxo.getAmounts().stream().map(amt -> {
            String unit = amt.getUnit();
            if (unit != null && unit.contains(".")) {
                unit = unit.replace(".", "");
            }
            return new Utxo.Amount(unit, amt.getQuantity());
        }).collect(Collectors.toList())).dataHash(dataHash).inlineDatum(addressUtxo.getInlineDatum()).referenceScriptHash(addressUtxo.getReferenceScriptHash()).epoch(addressUtxo.getEpoch()).blockNumber(addressUtxo.getBlockNumber()).blockTime(addressUtxo.getBlockTime()).build();
    }
}

