/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.client;

import com.bloxbean.cardano.yaci.store.api.utxo.service.AddressService;
import com.bloxbean.cardano.yaci.store.client.utxo.UtxoClient;
import com.bloxbean.cardano.yaci.store.common.domain.AddressUtxo;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.domain.UtxoKey;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import com.bloxbean.cardano.yaci.store.utxo.storage.UtxoStorage;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component(value="utxoClient")
@Primary
@ConditionalOnProperty(name={"store.enable.local.utxo.client"}, havingValue="true", matchIfMissing=true)
public class UtxoClientImpl
implements UtxoClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UtxoClientImpl.class);
    private UtxoStorage utxoStorage;
    private AddressService addressService;

    public UtxoClientImpl(UtxoStorage utxoStorage, AddressService addressService) {
        this.utxoStorage = utxoStorage;
        this.addressService = addressService;
        log.info("Enabled Local UtxoClient >>>");
    }

    public List<AddressUtxo> getUtxosByIds(List<UtxoKey> utxoIds) {
        return this.utxoStorage.findAllByIds(utxoIds);
    }

    public Optional<AddressUtxo> getUtxoById(@NotNull UtxoKey utxoId) {
        return this.utxoStorage.findById(utxoId.getTxHash(), utxoId.getOutputIndex().intValue());
    }

    public List<Utxo> getUtxoByAddress(@NotNull String address, int page, int count) {
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        if (address.startsWith("stake") || address.startsWith("stake_vkh")) {
            return this.addressService.getUtxoByStakeAddress(address, page, count, Order.asc);
        }
        return this.addressService.getUtxoByAddress(address, page, count, Order.asc);
    }
}

