/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.yaci.store.api.utxo.controller;

import com.bloxbean.cardano.yaci.store.api.utxo.service.AssetService;
import com.bloxbean.cardano.yaci.store.common.domain.Utxo;
import com.bloxbean.cardano.yaci.store.common.model.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="utxoAssetController")
@Tag(name="Asset Service")
@RequestMapping(value={"${apiPrefix}/assets"})
@ConditionalOnExpression(value="${store.utxo.endpoints.asset.enabled:true}")
public class AssetController {
    private final AssetService assetService;

    @Autowired
    public AssetController(AssetService assetService) {
        this.assetService = assetService;
    }

    @GetMapping(value={"/utxos/unit/{unit}"})
    @Operation(summary="Asset UTxOs by Unit", description="Get all UTxOs information of an asset.")
    public List<Utxo> getAssetUtxos(@PathVariable String unit, @RequestParam(name="page", defaultValue="0") @Min(value=0L) @Min(value=0L) int page, @RequestParam(name="count", defaultValue="10") @Min(value=1L) @Max(value=100L) @Min(value=1L) @Max(value=100L) int count, @RequestParam(required=false, defaultValue="asc") Order order) {
        int p = page;
        if (p > 0) {
            --p;
        }
        return this.assetService.getUtxosByAsset(unit, p, count, order);
    }
}

